var DeleteReportCtrl = (function () {
    function DeleteReportCtrl($scope, $modalInstance, language, templateName, reportTimestamps) {
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.$scope.ctrl = this;
        this.title =
            reportTimestamps.length === 1
                ? language.getElementValue('reportDeleteModalHdr')
                : language.getElementValue('reportsDeleteModalHdr');
        this.deleteReportsMessage =
            reportTimestamps.length === 1
                ? String.Format(language.getElementValue('reportPromtDeleteMsg'), templateName, reportTimestamps[0].toLongString())
                : String.Format(language.getElementValue('reportsPromtDeleteMsg'), templateName, reportTimestamps.length.toString());
    }
    DeleteReportCtrl.prototype.ok = function () {
        this.$modalInstance.close();
    };
    DeleteReportCtrl.prototype.close = function () {
        this.$modalInstance.dismiss();
    };
    DeleteReportCtrl.$inject = ['$scope', '$modalInstance', 'language', 'templateName', 'reportTimestamps'];
    return DeleteReportCtrl;
}());
angular.module('kamhpp').controller('deleteReportCtrl', DeleteReportCtrl);
