var ReportTemplateExportInfo = (function () {
    function ReportTemplateExportInfo(reportTemplateInfo) {
        this.uniqueGuid = reportTemplateInfo.uniqueGuid;
        this.name = reportTemplateInfo.name;
        this.chapter = reportTemplateInfo.chapter;
        this.isSelected = true;
    }
    return ReportTemplateExportInfo;
}());
var InformationExportingReportTemplatesModalCtrl = (function () {
    function InformationExportingReportTemplatesModalCtrl($modalInstance, reportTemplates) {
        this.$modalInstance = $modalInstance;
        this.isAllTemplatesSelected = true;
        this.reportChapters = [];
        this.searchTemplate = { name: '' };
        var reportGroupByChapter = _.groupBy(_.map(reportTemplates, function (template) { return new ReportTemplateExportInfo(template); }), function (item) {
            return item.chapter;
        });
        for (var key in reportGroupByChapter) {
            this.reportChapters.push(new ReportChapterInfo(key, reportGroupByChapter[key]));
        }
    }
    InformationExportingReportTemplatesModalCtrl.prototype.isChapterVisible = function (chapter) {
        var _this = this;
        return _.any(chapter.templates, function (template) {
            return template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase());
        });
    };
    InformationExportingReportTemplatesModalCtrl.prototype.changeAllTemplatesSelection = function () {
        var _this = this;
        if (this.searchTemplate.name === '') {
            _.forEach(this.reportChapters, function (chapter) {
                chapter.isSelected = !_this.isAllTemplatesSelected;
                _.forEach(chapter.templates, function (template) {
                    template.isSelected = !_this.isAllTemplatesSelected;
                });
            });
        }
        else {
            _.forEach(this.reportChapters, function (chapter) {
                _.forEach(chapter.templates, function (template) {
                    if (template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase())) {
                        template.isSelected = !_this.isAllTemplatesSelected;
                    }
                });
                chapter.isSelected = !_this.isAllTemplatesSelected;
            });
        }
    };
    InformationExportingReportTemplatesModalCtrl.prototype.changeChapterSelection = function (chapter) {
        var _this = this;
        chapter.isSelected = !chapter.isSelected;
        if (this.searchTemplate.name === '') {
            _.forEach(chapter.templates, function (template) {
                template.isSelected = chapter.isSelected;
            });
            this.isAllTemplatesSelected = _.all(this.reportChapters, function (chapter) { return _.all(chapter.templates, function (template) { return template.isSelected; }); });
        }
        else {
            _.forEach(chapter.templates, function (template) {
                if (template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase())) {
                    template.isSelected = chapter.isSelected;
                }
            });
            var filteredChapters = _.filter(this.reportChapters, function (chapter) { return !_.isEmpty(_.filter(chapter.templates, function (template) { return template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase()); })); });
            this.isAllTemplatesSelected = _.all(filteredChapters, function (chapter) { return chapter.isSelected; });
        }
    };
    InformationExportingReportTemplatesModalCtrl.prototype.changeTemplateSelection = function (template) {
        template.isSelected = !template.isSelected;
        this.checkAllSelected();
    };
    InformationExportingReportTemplatesModalCtrl.prototype.checkAllSelected = function () {
        var _this = this;
        _.forEach(this.reportChapters, function (chapter) {
            var filteredTemplates = _this.searchTemplate.name === ''
                ? chapter.templates
                : _.filter(chapter.templates, function (template) { return template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase()); });
            chapter.isSelected = _.all(filteredTemplates, function (template) { return template.isSelected; });
        });
        this.isAllTemplatesSelected = _.all(this.reportChapters, function (chapter) { return chapter.isSelected; });
    };
    InformationExportingReportTemplatesModalCtrl.prototype.ok = function () {
        var selectedReportTemplates = _.flatten(_.map(this.reportChapters, function (chapter) { return _.filter(chapter.templates, function (template) { return template.isSelected; }); }));
        this.$modalInstance.close(_.map(selectedReportTemplates, function (template) { return template.uniqueGuid; }));
    };
    InformationExportingReportTemplatesModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    InformationExportingReportTemplatesModalCtrl.$inject = [
        '$modalInstance',
        'reportTemplates',
    ];
    return InformationExportingReportTemplatesModalCtrl;
}());
app.controller('informationExportingReportTemplatesModalCtrl', InformationExportingReportTemplatesModalCtrl);
