var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ParameterConditionTrigger = (function (_super) {
    __extends(ParameterConditionTrigger, _super);
    function ParameterConditionTrigger(scope, reportParameters, language, source) {
        if (source === void 0) { source = null; }
        var _this = _super.call(this, source) || this;
        _this.language = language;
        _this.sourceType = 0;
        _this.type = 1;
        _this.watchFunctions = [];
        var self = _this;
        if (source) {
            self.parameterIdent = source.parameterIdent;
            self.etalon = source.etalon;
            self.conditionType = source.conditionType;
        }
        else {
            self.parameterIdent = '';
            self.conditionType = null;
            self.etalon = null;
        }
        self.etalonType = ParameterConditionTrigger.getEtalonType(_this.conditionType);
        var comparators = [
            new UiSelectReportCondition(0, _this.language.getElementValue('reportConditionContainsHdr'), ['string', 'string[]']),
            new UiSelectReportCondition(1, _this.language.getElementValue('reportConditionNotContainsHdr'), ['string', 'string[]']),
            new UiSelectReportCondition(2, _this.language.getElementValue('reportConditionEqualStringHdr'), ['string', 'string[]']),
            new UiSelectReportCondition(3, _this.language.getElementValue('reportConditionNotEqualStringHdr'), ['string', 'string[]']),
            new UiSelectReportCondition(4, _this.language.getElementValue('moreHdr'), [
                'double',
                'int',
                'WinccOaValue',
            ]),
            new UiSelectReportCondition(5, _this.language.getElementValue('equalHdr'), [
                'double',
                'int',
                'WinccOaValue',
            ]),
            new UiSelectReportCondition(6, _this.language.getElementValue('notEqualHdr'), [
                'double',
                'int',
                'WinccOaValue',
            ]),
            new UiSelectReportCondition(7, _this.language.getElementValue('lessHdr'), [
                'double',
                'int',
                'WinccOaValue',
            ]),
            new UiSelectReportCondition(8, _this.language.getElementValue('reportConditionIncludedInIntervalHdr'), ['double', 'int', 'WinccOaValue']),
            new UiSelectReportCondition(9, _this.language.getElementValue('reportConditionNotIncludedInIntervalHdr'), ['double', 'int', 'WinccOaValue']),
            new UiSelectReportCondition(10, _this.language.getElementValue('reportConditionTrueHdr'), [
                'Boolean',
            ]),
            new UiSelectReportCondition(11, _this.language.getElementValue('reportConditionFalseHdr'), [
                'Boolean',
            ]),
        ];
        self.conditions = getVariantsContainer(scope, comparators, function (t) {
            return t.ident === self.conditionType;
        }, function (after, before) {
            if (before === after)
                return;
            self.conditionType = after.ident;
            var etalonType = ParameterConditionTrigger.getEtalonType(after.ident);
            if (self.etalonType !== etalonType) {
                self.etalonType = etalonType;
            }
            if (after.ident === 11 || after.ident === 10) {
                self.etalon = after.ident === 10;
            }
        });
        var reportParameterTypeChanged = function (after, before) {
            switch (after) {
                case 'string':
                case 'string[]':
                    self.conditions.selected = _.find(self.conditions, function (item) {
                        return item.ident === 0;
                    });
                    break;
                case 'Boolean':
                    self.conditions.selected = _.find(self.conditions, function (item) {
                        return item.ident === 10;
                    });
                    break;
                default:
                    self.conditions.selected = _.find(self.conditions, function (item) {
                        return item.ident === 5;
                    });
                    break;
            }
        };
        var reportParameterSetChanged = function (after, before) {
            if (!_.isUndefined(before)) {
                self.reportParameters.destroy();
            }
            var filteredParameters = _.filter(after, function (i) {
                return (i.ParameterType === 'WinccOaValue' ||
                    i.ParameterType === 'string' ||
                    i.ParameterType === 'string[]' ||
                    i.ParameterType === 'double' ||
                    i.ParameterType === 'int' ||
                    i.ParameterType === 'Boolean');
            });
            if (self.parameterIdent !== '') {
                if (!_.any(after, function (p) { return p.Ident === self.parameterIdent; })) {
                    if (after.length == before.length) {
                        var beforeIndex_1 = _.findIndex(before, function (x) { return x.Ident === self.parameterIdent; });
                        if (after[beforeIndex_1] &&
                            _.any(filteredParameters, function (p) { return p.Ident == after[beforeIndex_1].Ident; })) {
                            self.parameterIdent = after[beforeIndex_1].Ident;
                        }
                    }
                    else if (after.length < before.length) {
                        self.parameterIdent = '';
                    }
                }
            }
            self.reportParameters = getVariantsContainer(scope, _.map(filteredParameters, function (parameter) {
                return new UiSelectReportParameter(parameter.Ident, parameter.ParameterType);
            }), function (t) {
                return t.ident === self.parameterIdent;
            }, function (after, before) {
                if (_.isUndefined(before) && _.isUndefined(after))
                    return;
                if (_.isDefined(before) && _.isDefined(after) && after.ident === before.ident)
                    return;
                self.parameterIdent = after.ident;
                if (_.isUndefined(before) || before.ParameterType !== after.ParameterType) {
                    reportParameterTypeChanged(after.ParameterType, _.isUndefined(before) ? null : before.ParameterType);
                }
            });
        };
        reportParameterSetChanged(reportParameters, undefined);
        self.watchFunctions.push(scope.$watch(function () { return reportParameters; }, reportParameterSetChanged, true));
        self.watchFunctions.push(scope.$watch(function () {
            return self.etalonType;
        }, function (after, before) {
            if (after === before) {
                return;
            }
            switch (after) {
                case 2:
                    self.etalon = '';
                    break;
                case 3:
                    self.etalon = true;
                    break;
                case 0:
                    self.etalon = {
                        min: 0,
                        max: 0,
                    };
                    break;
                default:
                    self.etalon = 0;
                    break;
            }
        }));
        self.watchFunctions.push(scope.$on('$destroy', function () {
            _.forEach(self.watchFunctions, function (func) {
                if (!_.isUndefined(func)) {
                    func();
                }
            });
        }));
        return _this;
    }
    ParameterConditionTrigger.prototype.getErrorMessages = function () {
        return !_.isDefined(this.parameterIdent) ||
            !_.isDefined(this.reportParameters.selected) ||
            this.parameterIdent === ''
            ? [new NotificationMessage(this.language.getElementValue('emptyConditionMsg'))]
            : [];
    };
    ParameterConditionTrigger.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (_super.isEqual.call(this, obj, other) &&
            obj.parameterIdent === other.parameterIdent &&
            _.isEqual(obj.etalon, other.etalon) &&
            obj.conditionType === other.conditionType);
    };
    ParameterConditionTrigger.getEtalonType = function (comparator) {
        switch (comparator) {
            case 0:
            case 1:
            case 2:
            case 3:
                return 2;
            case 10:
            case 11:
                return 3;
            case 8:
            case 9:
                return 0;
            default:
                return 1;
        }
    };
    return ParameterConditionTrigger;
}(BaseTrigger));
