var TemplatePrimarySettingsCtrl = (function () {
    function TemplatePrimarySettingsCtrl(scope, language) {
        var _this = this;
        this.periodicReportTypes = [];
        var self = this;
        this.scope = scope;
        this.language = language;
        this.periodicReportTypes = [
            { id: false, name: this.language.getElementValue('reportWithoutStepHdr') },
            { id: true, name: this.language.getElementValue('reportWithStepHdr') },
        ];
        this.setSelectedTemplate = function (t) {
            self.template = t;
            self.reportTypes = getVariantsContainer(self.scope, [
                new UiSelectItem(0, self.language.getElementValue('reportForTimeMomentSelectItem')),
                new UiSelectItem(1, self.language.getElementValue('reportPeriodicSelectItem')),
            ], function (t) {
                return t.ident === self.template.ReportType;
            }, function (after, before) {
                if (after === before || _.isUndefined(after)) {
                    return;
                }
                if (after.ident === 0) {
                    self.template.ReportType = 0;
                    self.template.HasStep = false;
                }
                else if (after.ident === 1) {
                    self.template.ReportType = 1;
                }
            });
            _this.reportStartDateTypes = getVariantsContainer(self.scope, [
                new UiSelectItem(0, _this.language.getElementValue('smsTimespanNowHdr')),
                new UiSelectItem(1, _this.language.getElementValue('smsTimespanHourHdr')),
                new UiSelectItem(2, _this.language.getElementValue('smsTimespanDayHdr')),
                new UiSelectItem(3, _this.language.getElementValue('smsTimespanMonthHdr')),
                new UiSelectItem(4, _this.language.getElementValue('smsTimespanYearHdr')),
            ], function (t) {
                return t.ident === self.template.ReportStartDateType;
            }, function (after, before) {
                if (after === before || _.isUndefined(after)) {
                    return;
                }
                self.template.ReportStartDateType = after.ident;
            });
            self.dateFormats = getVariantsContainer(self.scope, [
                new UiSelectItem(0, self.language.getElementValue('smsTimespanDayHdr')),
                new UiSelectItem(1, self.language.getElementValue('smsTimespanMonthHdr')),
                new UiSelectItem(2, self.language.getElementValue('smsTimespanYearHdr')),
            ], function (t) {
                return t.ident === self.template.ReportDateSelectionFormat;
            }, function (after, before) {
                if (after === before || _.isUndefined(after)) {
                    return;
                }
                self.template.ReportDateSelectionFormat = after.ident;
            });
        };
    }
    ;
    return TemplatePrimarySettingsCtrl;
}());
