var OleDbSettingsCtrl = (function () {
    function OleDbSettingsCtrl(parentScope, language) {
        this.parentScope = parentScope;
        this.language = language;
        this.functions = [];
        this.connectionTypes = [12];
        this.watchFunctions = [];
    }
    OleDbSettingsCtrl.prototype.init = function () {
        var self = this;
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem('table', this.language.getElementValue('sqlTableHtmlHdr'), 'ReportTable'),
            new SelectSourceFunctionsItem('cellString', this.language.getElementValue('reportCellStringHdr'), 'string'),
            new SelectSourceFunctionsItem('cellDouble', this.language.getElementValue('reportCellNumberHdr'), 'double'),
        ], function (t) {
            return t.ident === self.parentScope.param.OleDb.func;
        }, function (after, before) {
            if (after === before)
                return;
            if (after == undefined || after === before)
                return;
            self.parentScope.param.OleDb.func = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
            if (!self.canEdited()) {
                self.parentScope.param.Editable = false;
            }
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.OleDb;
        }, function (before, after) {
            if (_.isUndefined(self.parentScope.param.OleDb) ||
                _.isNull(self.parentScope.param.OleDb) ||
                after == undefined) {
                return;
            }
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    OleDbSettingsCtrl.prototype.destroy = function () {
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    OleDbSettingsCtrl.prototype.getFormula = function () {
        var connectionGuid = this.parentScope.param.OleDb.connectionGuid;
        var sql = ReportFormulaEscaper.escape(this.parentScope.param.OleDb.sql, this.parentScope.reportTemplate.Parameters);
        switch (this.functions.selected.ident) {
            case 'table':
                return ('return OleDbTableByConnection("' +
                    connectionGuid +
                    '", ' +
                    sql +
                    ', ' +
                    this.parentScope.param.OleDb.includeHeader +
                    ');');
            case 'doubleArray':
                return 'return OleDbDoubleArrayByConnection("' + connectionGuid + '", ' + sql + ');';
            case 'cellString':
                return 'return OleDbQueryAsStringByConnection("' + connectionGuid + '", ' + sql + ', 0, 0);';
            case 'cellDouble':
                return 'return OleDbQueryAsDoubleByConnection("' + connectionGuid + '", ' + sql + ', 0, 0);';
        }
        return '';
    };
    OleDbSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    OleDbSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.OleDb.canEdited();
    };
    OleDbSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.OleDb.canPlanned();
    };
    OleDbSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.OleDb.canBacklight();
    };
    OleDbSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.OleDb.canPredefined();
    };
    return OleDbSettingsCtrl;
}());
