var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var DictionaryDropdown = (function () {
    function DictionaryDropdown() {
        this.additionalVariants = [];
    }
    DictionaryDropdown.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new DictionaryDropdown();
        clone.dictionaryUniqueCode = obj.dictionaryUniqueCode;
        clone.classUniqueCode = obj.classUniqueCode;
        clone.parentInstanceParameterIdent = obj.parentInstanceParameterIdent;
        clone.additionalVariants = _.isArray(obj.additionalVariants) ? __spreadArray([], obj.additionalVariants, true) : [];
        return clone;
    };
    DictionaryDropdown.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return obj.dictionaryUniqueCode === other.dictionaryUniqueCode
            && obj.classUniqueCode === other.classUniqueCode
            && obj.parentInstanceParameterIdent === other.parentInstanceParameterIdent
            && _.isEqual(obj.additionalVariants, other.additionalVariants);
    };
    DictionaryDropdown.prototype.canEdited = function () {
        return false;
    };
    DictionaryDropdown.prototype.canPlanned = function () {
        return true;
    };
    DictionaryDropdown.prototype.canBacklight = function () {
        return true;
    };
    DictionaryDropdown.prototype.canPredefined = function () {
        return true;
    };
    return DictionaryDropdown;
}());
