var ChartPlotLinesSettingsModalCtrl = (function () {
    function ChartPlotLinesSettingsModalCtrl($scope, $modalInstance, plotLine, language) {
        var _this = this;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.plotLine = plotLine;
        this.language = language;
        $scope.ctrl = this;
        this.newPlotLine = _.deepclone(plotLine);
        this.dashStyles = [
            { dashStyle: 0, text: language.getElementValue('reportLineTypeDashHdr') },
            { dashStyle: 1, text: language.getElementValue('reportLineTypeDashDotHdr') },
            {
                dashStyle: 2,
                text: language.getElementValue('reportLineTypeDashDotDotHdr')
            },
            { dashStyle: 3, text: language.getElementValue('reportLineTypeDotHdr') },
            { dashStyle: 4, text: language.getElementValue('reportLineTypeSolidHdr') }
        ];
        this.selectedDashStyle = _.find(this.dashStyles, function (lineChartDashStyle) { return lineChartDashStyle.dashStyle === _this.newPlotLine.dashStyle; });
    }
    ChartPlotLinesSettingsModalCtrl.prototype.changeDashStyle = function () {
        this.newPlotLine.dashStyle = this.selectedDashStyle.dashStyle;
    };
    ChartPlotLinesSettingsModalCtrl.prototype.ok = function () {
        this.$modalInstance.close(this.newPlotLine);
    };
    ChartPlotLinesSettingsModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    ChartPlotLinesSettingsModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'plotLine',
        'language'
    ];
    return ChartPlotLinesSettingsModalCtrl;
}());
angular.module('kamhpp').controller('chartPlotLinesSettingsModalCtrl', ChartPlotLinesSettingsModalCtrl);
