var ChartCalloutViewType;
(function (ChartCalloutViewType) {
    ChartCalloutViewType[ChartCalloutViewType["None"] = 0] = "None";
    ChartCalloutViewType[ChartCalloutViewType["Self"] = 1] = "Self";
})(ChartCalloutViewType || (ChartCalloutViewType = {}));
var ChartExtraSettingsModalCtrl = (function () {
    function ChartExtraSettingsModalCtrl($scope, $modalInstance, chartType, series, language) {
        var _this = this;
        var _a, _b, _c;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.chartType = chartType;
        this.series = series;
        this.language = language;
        $scope.ctrl = this;
        this.newSeries = _.deepclone(series);
        this.chartLineTypes = [
            { type: 1, text: language.getElementValue('reportChartTypeSplineHdr') },
            { type: 0, text: language.getElementValue('reportChartLineHdr') },
            { type: 2, text: language.getElementValue('reportChartTypeSteplineHdr') }
        ];
        this.selectedChartLineType =
            (_a = _.find(this.chartLineTypes, function (chartType) { return chartType.type === _this.newSeries.type; })) !== null && _a !== void 0 ? _a : this.chartLineTypes[0];
        this.dashStyles = [
            { dashStyle: 0, text: language.getElementValue('reportLineTypeDashHdr') },
            { dashStyle: 1, text: language.getElementValue('reportLineTypeDashDotHdr') },
            {
                dashStyle: 2,
                text: language.getElementValue('reportLineTypeDashDotDotHdr')
            },
            { dashStyle: 3, text: language.getElementValue('reportLineTypeDotHdr') },
            { dashStyle: 4, text: language.getElementValue('reportLineTypeSolidHdr') }
        ];
        this.selectedDashStyle = _.find(this.dashStyles, function (lineChartDashStyle) { return lineChartDashStyle.dashStyle === _this.newSeries.lineDashStyle; });
        this.markerShapes = [
            { shape: 'circle', text: language.getElementValue('reportCalloutMarkerShapeCircleHdr') },
            { shape: 'square', text: language.getElementValue('reportCalloutMarkerShapeSquareHdr') },
            { shape: 'diamond', text: language.getElementValue('reportCalloutMarkerShapeDiamondHdr') },
            { shape: 'triangle', text: language.getElementValue('reportCalloutMarkerShapeTriangleHdr') }
        ];
        this.selectedMarkerShape =
            (_b = _.find(this.markerShapes, function (chartType) { var _a; return chartType.shape === ((_a = _this.newSeries.marker) === null || _a === void 0 ? void 0 : _a.shape); })) !== null && _b !== void 0 ? _b : this.markerShapes[0];
        this.needShowCallouts = _.isDefined(this.newSeries.callout);
        this.alignmentStyleTypes = [
            {
                type: 0,
                text: language.getElementValue('autoFitHdr')
            },
            {
                type: 10,
                text: language.getElementValue('reportCalloutVerticalAlignmentStyleHdr')
            },
            {
                type: 1,
                text: language.getElementValue('reportCalloutTopAlignmentStyleHdr')
            },
            {
                type: 2,
                text: language.getElementValue('reportCalloutBottomAlignmentStyleHdr')
            },
            {
                type: 3,
                text: language.getElementValue('reportCalloutRightAlignmentStyleHdr')
            },
            {
                type: 4,
                text: language.getElementValue('reportCalloutLeftAlignmentStyleHdr')
            },
            {
                type: 5,
                text: language.getElementValue('reportCalloutTopRightAlignmentStyleHdr')
            },
            {
                type: 6,
                text: language.getElementValue('reportCalloutTopRightAlignmentStyleHdr')
            },
            {
                type: 7,
                text: language.getElementValue('reportCalloutBottomLeftAlignmentStyleHdr')
            },
            {
                type: 8,
                text: language.getElementValue('reportCalloutBottomRightAlignmentStyleHdr')
            },
            {
                type: 9,
                text: language.getElementValue('reportCalloutCenterAlignmentStyleHdr')
            }
        ];
        this.selectedAlignmentStyleType =
            (_c = _.find(this.alignmentStyleTypes, function (alignmentType) { var _a; return alignmentType.type === ((_a = _this.newSeries.callout) === null || _a === void 0 ? void 0 : _a.alignmentStyles); })) !== null && _c !== void 0 ? _c : this.alignmentStyleTypes[0];
    }
    ChartExtraSettingsModalCtrl.prototype.changeAlignmentStyleType = function () {
        this.newSeries.callout.alignmentStyles = this.selectedAlignmentStyleType.type;
    };
    ChartExtraSettingsModalCtrl.prototype.ok = function () {
        this.$modalInstance.close(this.newSeries);
    };
    ChartExtraSettingsModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    ChartExtraSettingsModalCtrl.prototype.isLineChart = function () {
        return this.chartType === 0;
    };
    ChartExtraSettingsModalCtrl.prototype.isPieChart = function () {
        return this.chartType === 3;
    };
    ChartExtraSettingsModalCtrl.prototype.changeCalloutVisibility = function () {
        if (!this.needShowCallouts) {
            this.newSeries.callout = undefined;
        }
        else {
            if (!this.newSeries.callout) {
                this.newSeries.callout = {
                    labelInterval: 1,
                    labelOffset: 0,
                    distanceFromPoint: 5,
                    color: this.newSeries.color,
                    fontSize: 10,
                    alignmentStyles: 6
                };
            }
        }
    };
    ChartExtraSettingsModalCtrl.prototype.changeMarkerShape = function () {
        this.newSeries.marker.shape = this.selectedMarkerShape.shape;
    };
    ChartExtraSettingsModalCtrl.prototype.changeDashStyle = function () {
        this.newSeries.lineDashStyle = this.selectedDashStyle.dashStyle;
    };
    ChartExtraSettingsModalCtrl.prototype.changeLineType = function () {
        this.newSeries.type = this.selectedChartLineType.type;
    };
    ChartExtraSettingsModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'chartType',
        'series',
        'language'
    ];
    return ChartExtraSettingsModalCtrl;
}());
angular.module('kamhpp').controller('chartExtraSettingsModalCtrl', ChartExtraSettingsModalCtrl);
