var SwitchoverFormsCkeditorConfigurationProvider = (function () {
    function SwitchoverFormsCkeditorConfigurationProvider(modal, language) {
        this.modal = modal;
        this.language = language;
    }
    SwitchoverFormsCkeditorConfigurationProvider.prototype.getEditorConfiguration = function () {
        return {
            inline: true,
            trackFocus: true,
            buttons: [this.getPasteSwitchingInformationButtonConfiguration()],
            config: {
                toolbar: [
                    ['Font', 'FontSize'],
                    ['Bold', 'Italic', 'Underline', 'Strike'],
                    ['Paste', 'PasteText', 'RemoveFormat'],
                    ['NumberedList', 'BulletedList', 'Outdent', 'Indent'],
                    ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'],
                    ['base64image', 'Table', 'PasteSwitchingInformation', 'Sourcedialog'],
                ],
            },
        };
    };
    SwitchoverFormsCkeditorConfigurationProvider.prototype.getStepEditorConfiguration = function () {
        return {
            inline: true,
            config: {
                removePlugins: 'div, magicline, showborders',
                toolbar: [],
            },
        };
    };
    SwitchoverFormsCkeditorConfigurationProvider.prototype.getStepReadOnlyEditorConfiguration = function () {
        var editorConfiguration = this.getStepEditorConfiguration();
        editorConfiguration.config.readOnly = true;
        return editorConfiguration;
    };
    SwitchoverFormsCkeditorConfigurationProvider.prototype.getStepFullEditorConfiguration = function () {
        return {
            config: {
                toolbar: [
                    ['Font', 'FontSize'],
                    ['Bold', 'Italic', 'Underline', 'Strike'],
                    ['Paste', 'PasteText', 'RemoveFormat'],
                    ['NumberedList', 'BulletedList', 'Outdent', 'Indent'],
                    ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'],
                    ['Source'],
                ],
                removePlugins: 'showborders'
            },
        };
    };
    SwitchoverFormsCkeditorConfigurationProvider.prototype.getPasteSwitchingInformationButtonConfiguration = function () {
        var _this = this;
        return {
            button: {
                name: 'PasteSwitchingInformation',
                definition: {
                    command: 'pasteSwitchingInformation',
                    toolbar: '',
                    label: this.language.getElementValue('switchoverFormsAddSwitchingInfoModalHdr'),
                    icon: 'Form',
                },
            },
            command: {
                name: 'pasteSwitchingInformation',
                definition: {
                    exec: function (editor) {
                        _this.modal
                            .open({
                            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/AddSwitchingInfoModal/AddSwitchoverFormSwitchingInfoModal.html',
                            controller: 'addSwitchoverFormSwitchingInfoModalCtrl',
                            backdrop: 'static',
                            windowClass: 'app-modal-window',
                        })
                            .result.then(function (text) {
                            editor.insertHtml('%' + text + '%');
                        });
                        return true;
                    },
                },
            },
        };
    };
    SwitchoverFormsCkeditorConfigurationProvider.$inject = ['$modal', 'language'];
    return SwitchoverFormsCkeditorConfigurationProvider;
}());
angular
    .module('kamhpp')
    .service('switchoverFormsCkeditorConfigurationProvider', SwitchoverFormsCkeditorConfigurationProvider);
