var SwitchoverFormAlarm = (function () {
    function SwitchoverFormAlarm(alarm, opcSourceHdrLocal, winccoaHdrLocal) {
        var _this = this;
        this.opcSourceHdrLocal = opcSourceHdrLocal;
        this.winccoaHdrLocal = winccoaHdrLocal;
        this.id = alarm.id;
        this.name = alarm.name;
        this.commands = alarm.commands;
        this.switchoverFormId = alarm.switchoverFormId;
        this.switchoverForm = alarm.switchoverForm;
        this.commandText = _.map(this.commands, function (c) { return _this.getSourceDescription(c.source) + ': ' + c.tagAddress + ' = ' + c.value; });
    }
    SwitchoverFormAlarm.prototype.getSourceDescription = function (source) {
        switch (source) {
            case 0:
                return this.opcSourceHdrLocal;
            case 1:
                return this.winccoaHdrLocal;
            default:
                return '';
        }
    };
    return SwitchoverFormAlarm;
}());
var ViewAlarmsModalCtrl = (function () {
    function ViewAlarmsModalCtrl(scope, modal, language, alarms) {
        this.scope = scope;
        this.modal = modal;
        this.nameTextFilter = '';
        this.commandTextFilter = '';
        this.scope.ctrl = this;
        var sortedAlarms = _.sortBy(alarms, function (a) { return a.name; });
        this.alarms = _.map(sortedAlarms, function (a) {
            return new SwitchoverFormAlarm(a, language.getElementValue('opcSourceHdr'), language.getElementValue('winccoaHdr'));
        });
    }
    ViewAlarmsModalCtrl.prototype.close = function () {
        this.modal.close();
    };
    ViewAlarmsModalCtrl.$inject = ['$scope', '$modalInstance', 'language', 'alarms'];
    return ViewAlarmsModalCtrl;
}());
angular.module('kamhpp').controller('viewAlarmsModalCtrl', ViewAlarmsModalCtrl);
