var AddSignersSwitchoverFormModalCtrl = (function () {
    function AddSignersSwitchoverFormModalCtrl(scope, modal, users, appointments) {
        this.scope = scope;
        this.modal = modal;
        this.users = users;
        this.appointments = appointments;
        this.scope.ctrl = this;
        this.signers = _.map(appointments, function (appointment) {
            return { appointment: appointment, fullName: '', position: '' };
        });
        this.userNames = _.map(this.users, function (u) { return u.name; });
    }
    AddSignersSwitchoverFormModalCtrl.prototype.ok = function () {
        var _this = this;
        var fillSigners = _.where(this.signers, function (s) { return s.fullName !== ''; });
        _.forEach(fillSigners, function (signer) {
            var foundUser = _.find(_this.users, function (user) { return user.name === signer.fullName; });
            signer.position = _.isUndefined(foundUser) ? '' : foundUser.position;
        });
        this.modal.close(fillSigners);
    };
    AddSignersSwitchoverFormModalCtrl.prototype.allSignersEmpty = function () {
        return _.all(this.signers, function (signer) { return signer.fullName === ''; });
    };
    AddSignersSwitchoverFormModalCtrl.prototype.cancel = function () {
        this.modal.dismiss();
    };
    AddSignersSwitchoverFormModalCtrl.$inject = ['$scope', '$modalInstance', 'users', 'appointments'];
    return AddSignersSwitchoverFormModalCtrl;
}());
angular.module('kamhpp').controller('addSignersSwitchoverFormModalCtrl', AddSignersSwitchoverFormModalCtrl);
