var ExternalConnectionIsUsedModalCtrl = (function () {
    function ExternalConnectionIsUsedModalCtrl($scope, $modalInstance, language, connectionName, reportTemplates, isConnectionUsedInReports, isConnectionUsedInSwitchoverForms, isConnectionUsedInOperationTime) {
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.language = language;
        this.connectionName = connectionName;
        this.reportTemplates = reportTemplates;
        this.isConnectionUsedInReports = isConnectionUsedInReports;
        this.isConnectionUsedInSwitchoverForms = isConnectionUsedInSwitchoverForms;
        this.isConnectionUsedInOperationTime = isConnectionUsedInOperationTime;
        this.$scope.ctrl = this;
    }
    ExternalConnectionIsUsedModalCtrl.prototype.ok = function () {
        this.$modalInstance.close();
    };
    ExternalConnectionIsUsedModalCtrl.prototype.getConnectionUsageInfo = function () {
        var _a;
        var connectionUsedInfo = [{
                moduleName: this.language.getElementValue('reportsCpt') + ' (' + ((_a = this.reportTemplates) === null || _a === void 0 ? void 0 : _a.length.toString()) + ')',
                isUsed: this.isConnectionUsedInReports
            }, {
                moduleName: this.language.getElementValue('switchoverFormsCpt'),
                isUsed: this.isConnectionUsedInSwitchoverForms
            }, {
                moduleName: this.language.getElementValue('operationTimeCpt'),
                isUsed: this.isConnectionUsedInOperationTime
            }];
        var modulesNames = _.map(_.filter(connectionUsedInfo, function (info) { return info.isUsed; }), function (info) { return info.moduleName; }).join(', ');
        return String.Format(this.language.getElementValue('externalConnectionUsedMsg'), this.connectionName, modulesNames);
    };
    ExternalConnectionIsUsedModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'language',
        'connectionName',
        'reportTemplates',
        'isConnectionUsedInReports',
        'isConnectionUsedInSwitchoverForms',
        'isConnectionUsedInOperationTime'
    ];
    return ExternalConnectionIsUsedModalCtrl;
}());
angular.module('kamhpp').controller('externalConnectionIsUsedModalCtrl', ExternalConnectionIsUsedModalCtrl);
