var ServiceUnavailableViewController = (function () {
    function ServiceUnavailableViewController($scope, $interval, $modalInstance, appDiagnosticProvider, notificationService, language, statusCode) {
        var _this = this;
        this.$scope = $scope;
        this.$interval = $interval;
        this.$modalInstance = $modalInstance;
        this.appDiagnosticProvider = appDiagnosticProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.statusCode = statusCode;
        this.autoReconnectIntervalDelay = 60000;
        this.autoReconnectInterval = null;
        this.$scope.ctrl = this;
        this.$scope.$on('$destroy', function () {
            if (_this.autoReconnectInterval) {
                _this.$interval.cancel(_this.autoReconnectInterval);
            }
        });
        this.autoReconnectInterval = this.$interval(function () { _this.reconnect(); }, this.autoReconnectIntervalDelay);
    }
    ServiceUnavailableViewController.prototype.reconnect = function () {
        var _this = this;
        this.appDiagnosticProvider.isDatabaseAvailable()
            .then(function (isDatabaseAvailable) {
            if (isDatabaseAvailable) {
                _this.$modalInstance.close('ok');
            }
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ServiceUnavailableViewController.prototype.close = function () {
        this.$modalInstance.close('ok');
    };
    ServiceUnavailableViewController.$inject = [
        '$scope',
        '$interval',
        '$modalInstance',
        'appDiagnosticProvider',
        'notificationService',
        'language',
        'statusCode'
    ];
    return ServiceUnavailableViewController;
}());
angular.module('kamhpp').controller('serviceUnavailableViewCtrl', ServiceUnavailableViewController);
