var MailSendModalCtrl = (function () {
    function MailSendModalCtrl($scope, $modalInstance, mailValidationService, userPreferencesService, language, notificationService, subject, hideFileTypes) {
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.mailValidationService = mailValidationService;
        this.userPreferencesService = userPreferencesService;
        this.language = language;
        this.notificationService = notificationService;
        this.subject = subject;
        this.hideFileTypes = hideFileTypes;
        this.addresses = [''];
        this.recipients = [''];
        this.fileTypes = [
            new UiSelectItem(1, 'PDF'),
            new UiSelectItem(6, 'Docx'),
            new UiSelectItem(0, 'Excel'),
            new UiSelectItem(2, 'HTML'),
            new UiSelectItem(3, 'Txt'),
            new UiSelectItem(4, 'Xml'),
            new UiSelectItem(5, 'Csv'),
        ];
        this.selectedType = this.fileTypes[0];
        this.fileTypes = _.where(this.fileTypes, function (f) { return !_.any(hideFileTypes, function (s) { return s === f.ident; }); });
        this.$scope.ctrl = this;
        this.userPreferenses = userPreferencesService.getPreferences();
        this.recipients = this.userPreferenses.common.mailRecipients;
    }
    MailSendModalCtrl.prototype.ok = function () {
        var _this = this;
        var invalidAddresses = { value: [] };
        if (this.mailValidationService.isAddressesValid(this.addresses, invalidAddresses)) {
            this.userPreferenses.common.updateMailRecipientsPreferences(_.uniq(this.addresses));
            this.userPreferencesService.setPreferences(this.userPreferenses);
            this.$modalInstance.close({
                subject: this.subject,
                fileType: this.selectedType.ident,
                addressees: this.addresses,
                needArchive: false,
            });
        }
        else {
            _.forEach(invalidAddresses.value, function (address) {
                _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('reportWrongSingleEmailAddressMsg'), address));
            });
        }
    };
    MailSendModalCtrl.prototype.close = function () {
        this.$modalInstance.dismiss();
    };
    MailSendModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'mailValidationService',
        'userPreferencesService',
        'language',
        'notificationService',
        'subject',
        'hideFileTypes'
    ];
    return MailSendModalCtrl;
}());
angular.module('kamhpp').controller('mailSendModalCtrl', MailSendModalCtrl);
