var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var UsersSecurityCtrl = (function () {
    function UsersSecurityCtrl($q, $modal, notificationService, language, authentication, userProvider, roleProvider, userSessionProvider, licenseProvider, exportService) {
        var _this = this;
        this.$q = $q;
        this.$modal = $modal;
        this.notificationService = notificationService;
        this.language = language;
        this.authentication = authentication;
        this.userProvider = userProvider;
        this.roleProvider = roleProvider;
        this.userSessionProvider = userSessionProvider;
        this.licenseProvider = licenseProvider;
        this.exportService = exportService;
        this.sort = {
            columnName: 'name',
            descending: true
        };
        this.exportFormats = [
            new UiSelectItem('Excel', 'Excel'),
            new UiSelectItem('Csv', 'Csv'),
        ];
        this.filterFunction = function (user) {
            var _a, _b, _c;
            if (_.isUndefined(_this.userFilter) ||
                ((_a = user.name) === null || _a === void 0 ? void 0 : _a.toLowerCase().includes(_this.userFilter.toLowerCase())) ||
                ((_b = user.inlineRoleNames) === null || _b === void 0 ? void 0 : _b.toLowerCase().includes(_this.userFilter.toLowerCase())) ||
                ((_c = user.position) === null || _c === void 0 ? void 0 : _c.toLowerCase().includes(_this.userFilter.toLowerCase())) ||
                user.authenticationTypes.find(function (authenticationType) { return _this.getAuthenticationTypeString(authenticationType.type).toLowerCase().includes(_this.userFilter.toLowerCase()); })) {
                return user;
            }
        };
        this.loadUsers();
    }
    UsersSecurityCtrl.prototype.loadUsers = function () {
        var _this = this;
        var groupPromise = [
            this.userProvider.getAll(),
            this.roleProvider.getAll()
        ];
        this.$q.all(groupPromise).then(function (_a) {
            var users = _a[0], roles = _a[1];
            _this.users = users;
            _this.roles = roles;
            _.forEach(_this.users, function (user) {
                user.inlineRoleNames = _this.getUserInlineRoles(user);
                user.inlineAuthenticationTypes = _this.getUserInlineAuthenticationTypes(user);
            });
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    UsersSecurityCtrl.prototype.getUserInlineRoles = function (user) {
        return _.sortBy(_.map(this.getRoles(user), function (role) { return role.name; }), function (role) { return role; }).join(', ');
    };
    UsersSecurityCtrl.prototype.getUserInlineAuthenticationTypes = function (user) {
        var _this = this;
        return _.sortBy(_.map(user.authenticationTypes, function (authType) { return _this.getUserAuthenticationTypeString(authType.type); }), function (authType) { return authType; }).join(', ');
    };
    UsersSecurityCtrl.prototype.isInternalUser = function (userAuthenticationType) {
        return userAuthenticationType.type === 0;
    };
    UsersSecurityCtrl.prototype.getRoles = function (user) {
        return _.filter(this.roles, function (role) { return _.contains(user.roles, role.id); });
    };
    UsersSecurityCtrl.prototype.getUserRolesTitle = function (user) {
        return _.sortBy(_.map(this.getRoles(user), function (role) { return '• ' + role.name; }), function (role) { return role; }).join('\n');
    };
    UsersSecurityCtrl.prototype.changeSorting = function (columnName) {
        if (this.sort.columnName === columnName) {
            this.sort.descending = !this.sort.descending;
        }
        else {
            this.sort.columnName = columnName;
            this.sort.descending = false;
        }
    };
    UsersSecurityCtrl.prototype.exportTo = function (exportType) {
        var url = '/UserExport/ExportTo' + exportType;
        this.exportService.export(url);
    };
    UsersSecurityCtrl.prototype.getUserAuthenticationTypes = function (user) {
        var _this = this;
        return _.map(user.authenticationTypes, function (authType) { return _this.getUserAuthenticationTypeString(authType.type); }).join('; ');
    };
    UsersSecurityCtrl.prototype.getUserAuthenticationTypeString = function (type) {
        if (type === 1) {
            return this.language.getElementValue('securityDomainMsg');
        }
        if (type === 2) {
            return this.language.getElementValue('securityLdapMsg');
        }
        if (type === 3) {
            return this.language.getElementValue('securityCtaMsg');
        }
        return this.language.getElementValue('securityInternalMsg');
    };
    UsersSecurityCtrl.prototype.createNewUser = function (user) {
        var _this = this;
        if (user === void 0) { user = undefined; }
        this.licenseProvider
            .getLicense()
            .then(function (license) {
            if (_.isDefined(license.usersCount) && _this.users.length >= license.usersCount + 2) {
                _this.notificationService.errorMessage(String.Format(_this.language.getElementValue('reportUsersCountAvailableInLicenseMsg'), license.usersCount.toString()));
                return;
            }
            var modalInstance = _this.$modal.open({
                templateUrl: 'ng1/dist/src/Administration/Security/Users/UserSettingsModal/UserSettingsModal.html',
                controller: 'UserSettingsModalCtrl',
                windowClass: 'app-modal-window level-one',
                backdrop: 'static',
                keyboard: false,
                resolve: {
                    user: function () {
                        return user;
                    },
                    users: function () {
                        return _this.users;
                    },
                    roles: function () {
                        return _this.roles;
                    },
                    isAdmin: function () {
                        return false;
                    }
                }
            });
            modalInstance.result.then(function (newUser) {
                _this.userProvider.create(newUser).then(function () {
                    var extendUser = newUser;
                    extendUser.inlineRoleNames = _this.getUserInlineRoles(newUser);
                    extendUser.inlineAuthenticationTypes = _this.getUserInlineAuthenticationTypes(newUser);
                    _this.users.push(extendUser);
                    _this.notificationService.showMessage(String.Format(_this.language.getElementValue('securitySuccessAddUserMsg'), newUser.name));
                }, function (error) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
                });
            }, function () { });
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    UsersSecurityCtrl.prototype.edit = function (user) {
        var _this = this;
        var modalInstance = this.$modal.open({
            templateUrl: 'ng1/dist/src/Administration/Security/Users/UserSettingsModal/UserSettingsModal.html',
            controller: 'UserSettingsModalCtrl',
            windowClass: 'app-modal-window level-one',
            backdrop: 'static',
            keyboard: false,
            resolve: {
                user: function () {
                    return user;
                },
                users: function () {
                    return _this.users;
                },
                roles: function () {
                    return _this.roles;
                }
            }
        });
        modalInstance.result.then(function (newUser) {
            _this.userProvider.update(newUser).then(function () {
                var _a;
                var needToLogout = user.id === ((_a = _this.authentication.user) === null || _a === void 0 ? void 0 : _a.id);
                user.isActive = newUser.isActive;
                user.authenticationTypes = __spreadArray([], newUser.authenticationTypes, true);
                user.name = newUser.name;
                user.position = newUser.position;
                user.signature = newUser.signature;
                user.roles = __spreadArray([], newUser.roles, true);
                user.inlineRoleNames = _this.getUserInlineRoles(user);
                user.inlineAuthenticationTypes = _this.getUserInlineAuthenticationTypes(newUser);
                _this.notificationService.showMessage(String.Format(_this.language.getElementValue('securitySuccessUpdateUserMsg'), newUser.name));
                if (needToLogout) {
                    _this.authentication.logout();
                }
            }, function (error) {
                _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
            });
        }, function () { });
    };
    UsersSecurityCtrl.prototype.delete = function (user) {
        var _this = this;
        this.$modal
            .open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoModal.html',
            controller: 'yesNoModalCtrl',
            backdrop: 'static',
            resolve: {
                header: function () { return _this.language.getElementValue('securityUserConfirmDeleteHdr'); },
                body: function () { return String.Format(_this.language.getElementValue('securityUserConfirmDeleteMsg'), user.name); }
            }
        })
            .result.then(function () {
            _this.userProvider.delete(user.id).then(function () {
                _this.users = _.filter(_this.users, function (u) { return u.id !== user.id; });
                _this.notificationService.showMessage(String.Format(_this.language.getElementValue('securitySuccessDeleteUserMsg'), user.name));
            }, function (error) {
                _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
            });
        }, function () { });
    };
    UsersSecurityCtrl.prototype.removeLocation = function (user) {
        var _this = this;
        this.userSessionProvider.removeAllUserSessionsByUserGuid(user.id)
            .then(function () {
            user.isOnline = false;
            _this.notificationService.showMessage(_this.language.getElementValue('userSessionClosedSuccesfullyHdr'));
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    UsersSecurityCtrl.prototype.getAuthenticationTypeString = function (authenticationType) {
        switch (authenticationType) {
            case 0:
                return this.language.getElementValue('securityInternalMsg');
            case 3:
                return this.language.getElementValue('securityCtaMsg');
            case 1:
                return this.language.getElementValue('securityDomainMsg');
            case 2:
                return this.language.getElementValue('securityLdapMsg');
        }
    };
    UsersSecurityCtrl.inject = [
        '$q',
        '$modal',
        'notificationService',
        'language',
        'authentication',
        'userProvider',
        'roleProvider',
        'userSessionProvider',
        'licenseProvider',
        'exportService'
    ];
    return UsersSecurityCtrl;
}());
angular.module('kamhpp').controller('UsersSecurityCtrl', UsersSecurityCtrl);
