var ServerDiagnosticCtrl = (function () {
    function ServerDiagnosticCtrl($modal, notificationService, appDiagnosticProvider, coreConfigurationProvider, clusterServerProvider, language, licenseProvider, jobSchedulerProvider, dateFilter) {
        this.$modal = $modal;
        this.notificationService = notificationService;
        this.appDiagnosticProvider = appDiagnosticProvider;
        this.coreConfigurationProvider = coreConfigurationProvider;
        this.clusterServerProvider = clusterServerProvider;
        this.language = language;
        this.licenseProvider = licenseProvider;
        this.jobSchedulerProvider = jobSchedulerProvider;
        this.dateFilter = dateFilter;
        this.serversInfo = [];
        this.dateFormat = Date.masks.fullDateTime;
        this.jobs = [];
        this.isJobSchedulerEnabled = false;
        this.licenseSource = null;
        this.sendMailsJobId = 'SendMailsJob';
        this.deleteMailsJobId = 'DeleteMailsJob';
        this.calculateOperationTimeJobId = 'CalculateOperationTimeJob';
        this.uploadReportValuesJobId = 'UploadReportValuesJob';
        this.processReportsCreationRulesJobId = 'ProcessReportsCreationRulesJob';
        this.processReportsRulesJobId = 'ProcessReportsRulesJob';
        this.deleteLogsJob = 'DeleteLogsJob';
        this.infinitySymbol = '∞';
        this.refresh();
    }
    ServerDiagnosticCtrl.prototype.refresh = function () {
        var _this = this;
        this.coreConfigurationProvider
            .getVersion()
            .then(function (version) { return (_this.version = version); })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error); });
        this.loadServersInfo();
        this.loadLicense();
        this.loadPeriodicJobs();
    };
    ServerDiagnosticCtrl.prototype.loadServersInfo = function () {
        var _this = this;
        this.appDiagnosticProvider
            .getDriveInfo()
            .then(function (driveSpaceInfo) { return _this.driveSpaceInfo = driveSpaceInfo; })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error); });
        this.clusterServerProvider
            .isClusteringEnabled()
            .then(function (isEnabled) {
            _this.isServerClusterVisible = isEnabled;
            if (!isEnabled) {
                return;
            }
            _this.clusterServerProvider
                .getServersInfo()
                .then(function (serversInfo) {
                _this.serversInfo = serversInfo;
                _this.onRefresh();
            })
                .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error); });
        })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error); });
    };
    ServerDiagnosticCtrl.prototype.loadServerInfo = function (index, address) {
        var _this = this;
        this.clusterServerProvider
            .getServerInfo(address)
            .then(function (serverInfo) { return _this.serversInfo[index] = serverInfo; })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error); });
    };
    ServerDiagnosticCtrl.prototype.getServerStatus = function (status) {
        switch (status) {
            case 2:
                return this.language.getElementValue('clusterServerStatusPrimaryMsg');
            case 1:
                return this.language.getElementValue('clusterServerStatusStandbyMsg');
            case 0:
                return this.language.getElementValue('clusterServerStatusUnknownMsg');
        }
    };
    ServerDiagnosticCtrl.prototype.loadLicense = function () {
        var _this = this;
        this.licenseProvider
            .getLicenseSettingsInfo()
            .then(function (license) {
            _this.license = license;
            _this.onRefresh();
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
        this.appDiagnosticProvider.getLicenseInfo()
            .then(function (licnseInfo) {
            _this.isLicenseExpiring = licnseInfo.isLicenseExpiring;
            _this.licenseGracePeriodEnd = licnseInfo.gracePeriodEnd;
            _this.licenseSource = licnseInfo.source;
        });
    };
    ServerDiagnosticCtrl.prototype.isLicenseFromFile = function () {
        return this.licenseSource === 0;
    };
    ServerDiagnosticCtrl.prototype.getUsersCountInfo = function () {
        return "".concat(this.license.currentUsersCount, " \n            / ").concat(_.isDefined(this.license.usersCount)
            ? this.license.usersCount
            : this.infinitySymbol);
    };
    ServerDiagnosticCtrl.prototype.getDevicesCountInfo = function () {
        return "".concat(this.license.currentDevicesCount, " \n            / ").concat(_.isDefined(this.license.devicesCount)
            ? this.license.devicesCount
            : this.infinitySymbol);
    };
    ServerDiagnosticCtrl.prototype.getReportTemplatesCountInfo = function () {
        return "".concat(this.license.currentReportTemplatesCount, " \n            / ").concat(_.isDefined(this.license.modules.reports.templatesCount)
            ? this.license.modules.reports.templatesCount
            : this.infinitySymbol);
    };
    ServerDiagnosticCtrl.prototype.getSwitchoverFormTemplatesCountInfo = function () {
        return "".concat(this.license.currentSwitchoverFormTemplatesCount, " \n            / ").concat(_.isDefined(this.license.modules.switchoverForms.templatesCount)
            ? this.license.modules.switchoverForms.templatesCount
            : this.infinitySymbol);
    };
    ServerDiagnosticCtrl.prototype.getExpirationDateInfo = function () {
        return _.isDefined(this.license.expirationDate)
            ? this.dateFilter(this.license.expirationDate, 'dd.MM.yyyy')
            : this.infinitySymbol;
    };
    ServerDiagnosticCtrl.prototype.getLicenseModulesNames = function () {
        var modulesNames = [];
        if (this.license.modules.reports) {
            modulesNames.push(this.language.getElementValue('reportsCpt'));
        }
        if (this.license.modules.switchoverForms) {
            modulesNames.push(this.language.getElementValue('switchoverFormsCpt'));
        }
        if (this.license.modules.operationTime) {
            modulesNames.push(this.language.getElementValue('operationTimeCpt'));
        }
        if (this.license.modules.cim) {
            modulesNames.push(this.language.getElementValue('cimCpt'));
        }
        return modulesNames;
    };
    ServerDiagnosticCtrl.prototype.addNewLicense = function () {
        this.$modal
            .open({
            templateUrl: 'ng1/dist/src/Core/License/LicenseWindow/ActivationLicenseWindow.html',
            controller: 'licenseWindowController',
            backdrop: 'true',
            resolve: {
                canBeClosed: function () { return true; },
                licenseState: function () { return ''; },
                missingModules: function () { return ''; }
            }
        })
            .result.then(function () { });
    };
    ServerDiagnosticCtrl.prototype.loadPeriodicJobs = function () {
        this.refreshJobSchedulerStatus();
        this.loadJobsInfo();
    };
    ServerDiagnosticCtrl.prototype.executeJob = function (jobId) {
        var _this = this;
        this.jobSchedulerProvider
            .executeJob(jobId)
            .then(function () {
            _this.notificationService.showMessage(_this.language.getElementValue('periodicJobSuccessMsg'));
            _this.loadPeriodicJobs();
            _this.onRefresh();
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('periodicJobFailureMsg'), error.data);
        });
    };
    ServerDiagnosticCtrl.prototype.getJobName = function (jobId) {
        switch (jobId) {
            case this.sendMailsJobId:
                return this.language.getElementValue('sendMailsJobNameHdr');
            case this.deleteMailsJobId:
                return this.language.getElementValue('deleteMailsJobNameHdr');
            case this.calculateOperationTimeJobId:
                return this.language.getElementValue('calculateOperationTimeJobNameHdr');
            case this.uploadReportValuesJobId:
                return this.language.getElementValue('uploadReportValuesJobNameHdr');
            case this.processReportsCreationRulesJobId:
                return this.language.getElementValue('processReportsCreationRulesJobNameHdr');
            case this.processReportsRulesJobId:
                return this.language.getElementValue('processReportsRulesJobNameHdr');
            case this.deleteLogsJob:
                return this.language.getElementValue('deleteLogsJobNameHdr');
        }
    };
    ServerDiagnosticCtrl.prototype.getJobDescription = function (jobId) {
        switch (jobId) {
            case this.sendMailsJobId:
                return this.language.getElementValue('sendMailsJobDescriptionHdr');
            case this.deleteMailsJobId:
                return this.language.getElementValue('deleteMailsJobDescriptionHdr');
            case this.calculateOperationTimeJobId:
                return this.language.getElementValue('calculateOperationTimeJobDescriptionHdr');
            case this.uploadReportValuesJobId:
                return this.language.getElementValue('uploadReportValuesJobDescriptionHdr');
            case this.processReportsCreationRulesJobId:
                return this.language.getElementValue('processReportsCreationRulesJobDescriptionHdr');
            case this.processReportsRulesJobId:
                return this.language.getElementValue('processReportsRulesJobDescriptionHdr');
            case this.deleteLogsJob:
                return this.language.getElementValue('deleteLogsJobDescriptionHdr');
        }
    };
    ServerDiagnosticCtrl.prototype.loadJobsInfo = function () {
        var _this = this;
        this.jobSchedulerProvider.getJobsInfo().then(function (jobsInfo) {
            _this.jobs = _.filter(jobsInfo, function (job) { return job.isEnabled; });
            _this.onRefresh();
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ServerDiagnosticCtrl.prototype.refreshJobSchedulerStatus = function () {
        var _this = this;
        this.jobSchedulerProvider.isJobSchedulerEnabled().then(function (isJobSchedulerEnabled) {
            _this.isJobSchedulerEnabled = isJobSchedulerEnabled;
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ServerDiagnosticCtrl.prototype.isRunned = function (job) {
        return !_.isNull(job.lastRunTime);
    };
    ServerDiagnosticCtrl.$inject = [
        '$modal',
        'notificationService',
        'appDiagnosticProvider',
        'coreConfigurationProvider',
        'clusterServerProvider',
        'language',
        'licenseProvider',
        'jobSchedulerProvider',
        'dateFilter'
    ];
    return ServerDiagnosticCtrl;
}());
angular.module('kamhpp').controller('ServerDiagnosticCtrl', ServerDiagnosticCtrl);
