var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var CoreConfigurationCtrl = (function (_super) {
    __extends(CoreConfigurationCtrl, _super);
    function CoreConfigurationCtrl($scope, $rootScope, $route, coreConfiguration, coreConfigurationProvider, notificationService, language) {
        var _this = _super.call(this, $scope) || this;
        _this.$rootScope = $rootScope;
        _this.$route = $route;
        _this.coreConfiguration = coreConfiguration;
        _this.coreConfigurationProvider = coreConfigurationProvider;
        _this.notificationService = notificationService;
        _this.language = language;
        _this.languages = [
            new UiSelectItem(0, 'Русский'),
            new UiSelectItem(1, 'English')
        ];
        _this.selectedLanguage = _this.languages[0];
        _this.loadConfiguration();
        return _this;
    }
    CoreConfigurationCtrl.prototype.loadConfiguration = function () {
        var _this = this;
        this.coreConfigurationProvider
            .getCoreConfiguration()
            .then(function (configuration) {
            _this.configuration = configuration;
            _this.selectedLanguage = _.find(_this.languages, function (item) { return item.ident === configuration.language; });
            _this.databaseConnection = configuration.databaseConnection;
            _this.dbmsName = _this.getDatabaseTypeName(configuration.databaseConnection);
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    CoreConfigurationCtrl.prototype.saveConfiguration = function () {
        var _this = this;
        if (_.isBlank(this.configuration.startPageUrl)) {
            this.notificationService.warnMessage(this.language.getElementValue('allFieldsMustFilledMsg'));
            return;
        }
        if (!this.isRouteExists()) {
            this.notificationService.warnMessage(this.language.getElementValue('invalidStartPageUrlMsg'));
            return;
        }
        return this.coreConfigurationProvider
            .saveCoreConfiguration(this.configuration)
            .then(function () {
            _this.$rootScope.$broadcast('languageChanged', { language: _this.selectedLanguage.ident });
            _this.coreConfiguration.applicationTitle = _this.configuration.applicationTitle;
            _this.coreConfiguration.startPageUrl = _this.configuration.startPageUrl;
            _this.coreConfiguration.language = _this.configuration.language;
            _this.language.setLanguage(_this.configuration.language);
            _this.hasChanges = false;
            _this.notificationService.showMessage(_this.language.getElementValue('changesSuccessSaveMsg'));
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedSaveChangesMsg'), error);
        });
    };
    CoreConfigurationCtrl.prototype.onLanguageChanged = function () {
        this.configuration.language = this.selectedLanguage.ident;
        this.onConfigurationChanged();
    };
    CoreConfigurationCtrl.prototype.onConfigurationChanged = function () {
        this.hasChanges = true;
    };
    CoreConfigurationCtrl.prototype.getDatabaseTypeName = function (databaseConnection) {
        switch (databaseConnection.type) {
            case 2:
                return 'Microsoft SQL Server';
            case 0:
                return 'PostgreSQL';
            case 1:
                return 'SQLite';
            case 3:
                return 'MariaDB';
            default:
                return '';
        }
    };
    CoreConfigurationCtrl.prototype.isRouteExists = function () {
        var pageUrl = '/' + this.configuration.startPageUrl;
        return _.any(Object.keys(this.$route.routes), function (route) {
            if (route.lastIndexOf(pageUrl) === 0) {
                return true;
            }
            if (!route.includes(':')) {
                return false;
            }
            var regex = new RegExp('^' + route.replace(/:\w+/g, '\\w+') + '$');
            if (regex.test(pageUrl)) {
                return true;
            }
            return false;
        });
    };
    CoreConfigurationCtrl.$inject = [
        '$scope',
        '$rootScope',
        '$route',
        'coreConfiguration',
        'coreConfigurationProvider',
        'notificationService',
        'language'
    ];
    return CoreConfigurationCtrl;
}(BaseConfigurationController));
angular
    .module('kamhpp')
    .controller('CoreConfigurationCtrl', CoreConfigurationCtrl);
