BEGIN TRANSACTION;

-- Сохраняем данные из таблицы UserRoles, т.к. есть каскадное удаление, а sqlite не дает отключить внешние ключи при транзакции
CREATE TEMPORARY TABLE tempUserRoles AS
SELECT
  UserId,
  RoleId
FROM UserRoles;

-- Удаляем колонку IsDomain из таблицы Users
CREATE TEMPORARY TABLE temp AS
SELECT
  Id,
  Login,
  Name,
  Password,
  IsActive,
  Position,
  Signature,
  SigningAuthority,
  AuthenticationType
FROM Users;

DROP TABLE Users;

CREATE TABLE Users (
	Id TEXT,
	Login TEXT,
	Name TEXT,
	Password TEXT,
	IsActive INTEGER,
	Position TEXT,
	Signature BLOB,
	SigningAuthority TEXT,
	AuthenticationType INTEGER DEFAULT (0),
	CONSTRAINT USERS_PK PRIMARY KEY (Id)
);

INSERT INTO Users
 (Id,
  Login,
  Name,
  Password,
  IsActive,
  Position,
  Signature,
  SigningAuthority,
  AuthenticationType)
SELECT
  Id,
  Login,
  Name,
  Password,
  IsActive,
  Position,
  Signature,
  SigningAuthority,
  AuthenticationType
FROM temp;

DROP TABLE temp;

-- Удаляем колонку IsDomainUserGroup из таблицы Roles

CREATE TEMPORARY TABLE temp AS
SELECT
  Id,
  Name,
  PermissionIdents
FROM Roles;

DROP TABLE Roles;

CREATE TABLE Roles (
	Id TEXT,
	Name TEXT,
	PermissionIdents TEXT,
	CONSTRAINT ROLES_PK PRIMARY KEY (Id)
);

INSERT INTO Roles
 (Id,
  Name,
  PermissionIdents)
SELECT
  Id,
  Name,
  PermissionIdents
FROM temp;

DROP TABLE temp;

-- Возвращаем связь пользователей и ролей

INSERT INTO UserRoles
  (UserId,
  RoleId)
SELECT
  UserId,
  RoleId
FROM tempUserRoles;

DROP TABLE tempUserRoles;

COMMIT;