﻿BEGIN TRANSACTION;

DROP TABLE "Mails";

CREATE TABLE "Mails" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_Mail" PRIMARY KEY AUTOINCREMENT,
    "CreationDate" TEXT NOT NULL,
    "SendingDate" TEXT NULL,
    "SenderAdress" TEXT NOT NULL,
    "RecipientsAddresses" TEXT NOT NULL,
    "Subject" TEXT NOT NULL,
    "Body" TEXT NULL,
    "IsSent" INTEGER NOT NULL
);

CREATE TABLE "MailAttachments" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_MailAttachments" PRIMARY KEY AUTOINCREMENT,
    "MailId" INTEGER NOT NULL,
    "Name" TEXT NOT NULL,
    "ContentMediaType" TEXT NOT NULL,
    "ContentStream" BLOB NOT NULL,
    CONSTRAINT "FK_MailAttachments_Mails_MailId" FOREIGN KEY ("MailId") REFERENCES "Mails" ("Id") ON DELETE CASCADE
);

CREATE INDEX "IX_Mail_Id" ON "Mails" ("Id");

CREATE INDEX "IX_MailAttachments_MailId" ON "MailAttachments" ("MailId");

INSERT INTO "__EFMigrationsHistory" ("MigrationId", "ProductVersion")
VALUES ('20220201072119_UpdateMailTable', '5.0.2');

COMMIT;

