DO $$ 
DECLARE
v_id UUID;  -- Тип данных для ID, если Id — это UUID
    v_algorithm TEXT;
    v_varname TEXT;
    v_escaped_varname TEXT;
    v_constantname TEXT;
BEGIN
    -- Перебираем все параметры из OTParameters
FOR v_id, v_algorithm IN
SELECT "Id", "Algorithm" FROM "td"."OTParameters"
    LOOP
                            -- Перебираем все переменные, относящиеся к текущему параметру
    FOR v_varname, v_escaped_varname IN
SELECT "Name", '%' || "Name" || '%' FROM "td"."OTAlgorithmParameters"
WHERE "ParameterId" = v_id
ORDER BY "Name"
    LOOP
            -- Обновляем алгоритм, заменяя переменную на экранированную версию
            v_algorithm := REPLACE(v_algorithm, v_varname, v_escaped_varname);
END LOOP;

        -- Перебираем все константы, относящиеся к текущему параметру
FOR v_constantname IN
SELECT "Name" FROM "td"."OTAlgorithmConstants"
WHERE "ParameterId" = v_id
    LOOP
            -- Экранируем константу, добавляя символы '%'
            v_algorithm := REPLACE(v_algorithm, v_constantname, '%' || v_constantname || '%');
END LOOP;

        -- Обновляем запись в OTParameters
UPDATE "td"."OTParameters"
SET "Algorithm" = v_algorithm
WHERE "Id" = v_id;
END LOOP;
END $$;
