UPDATE "td"."OTParameters"
SET
    "CalculationEndDate" = (
        SELECT CASE
                   WHEN s."Value" IS NULL OR s."Value" = 'DEFAULT_VALUE' THEN NULL
                   ELSE s."Value"::timestamp
END
FROM "td"."ServerSettings" AS s
        WHERE s."Name" = 'OperationTime:LastCalculationTime'
    ),
    "CalculationStartDate" = (
        CASE
            WHEN EXISTS (
                SELECT 1 FROM "td"."OTRecords"
                JOIN "td"."OTDevices" ON "td"."OTDevices"."Id" = "td"."OTRecords"."DeviceId"
                WHERE "td"."OTDevices"."ParameterId" = "td"."OTParameters"."Id"
            )
            THEN (
                SELECT MIN("td"."OTRecords"."TimeStamp")
                FROM "td"."OTRecords"
                JOIN "td"."OTDevices" ON "td"."OTDevices"."Id" = "td"."OTRecords"."DeviceId"
                WHERE "td"."OTDevices"."ParameterId" = "td"."OTParameters"."Id"
            )
            ELSE "CalculationStartDate"
        END
    );
