﻿BEGIN TRANSACTION;

DROP TABLE [Mails];

CREATE TABLE [Mails] (
    [Id] INT IDENTITY NOT NULL,
    [CreationDate] DATETIME NOT NULL,
    [SendingDate] DATETIME NULL,
    [SenderAdress] NVARCHAR(128) NOT NULL,
    [RecipientsAddresses] NVARCHAR(MAX) NOT NULL,
    [Subject] NVARCHAR(128) NOT NULL,
    [Body] NVARCHAR(MAX) NULL,
    [IsSent] BIT NOT NULL,
    CONSTRAINT [PK_Mails] PRIMARY KEY ([Id])
);

CREATE TABLE [MailAttachments] (
    [Id] INT IDENTITY NOT NULL,
    [MailId] INT NOT NULL,
    [Name] NVARCHAR(128) NOT NULL,
    [ContentMediaType] NVARCHAR(128) NOT NULL,
    [ContentStream] VARBINARY(MAX) NOT NULL,
    CONSTRAINT [PK_MailAttachments] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_MailAttachments_Mails_MailId] FOREIGN KEY ([MailId]) REFERENCES [Mails] ([Id]) ON DELETE CASCADE
);

CREATE INDEX [IX_Mail_Id] ON [Mails] ([Id]);

CREATE INDEX [IX_MailAttachments_MailId] ON [MailAttachments] ([MailId]);

INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
VALUES ('20220225100102_UpdateMailTable', '5.0.2');

COMMIT;
