// Скрипт для группировки ключей локализации
// Перевод из
// {
//     "administration.server.core":"Основные"
// }
//
// к такому виду
// {
//     "administration": {
//          "server": {
//              "core": "Основные"
//          }
//     }
// }
//
// todo: можно перевести на .ts или .mts
// todo: ещё можно удалять неиспользуемые ключи
// todo: ещё можно проверять, что некоторые ключи имеют только одну локализацию

import * as fs from 'fs';

/**
 *
 * @param obj Текущий node (узел) дерева словаря
 * @param key Ключ
 * @param value Значение
 */
function setNestedKey(obj, key, value) {
    const keys = key.split('.');
    let current = obj;

    keys.forEach((k, i) => {
        if (i === keys.length - 1) {
            current[k] = value;
        } else {
            current[k] = current[k] || {};
            current = current[k];
        }
    });
}

/**
 *
 * @param filePath путь к файлу локализации
 */
function convertKeysToNested(filePath) {
    const data = fs.readFileSync(filePath, 'utf-8');
    const flatJson = JSON.parse(data);
    const nestedJson = {};

    Object.keys(flatJson).forEach((key) => {
        setNestedKey(nestedJson, key, flatJson[key]);
    });

    fs.writeFileSync(filePath, JSON.stringify(nestedJson, null, 2));

    // Сообщение об успешном завершении
    // eslint-disable-next-line no-undef
    console.log(`Файл ${filePath} успешно преобразован и сохранен!`);
}

// Использование: путь к файлу JSON
convertKeysToNested('./src/shared/assets/translation/i18n/ru.json');
convertKeysToNested('./src/shared/assets/translation/i18n/en.json');
