angular.module('dataServiceProvider', []);
var AdsiProviderService = (function () {
    function AdsiProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    AdsiProviderService.prototype.getDomainGroupsTree = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/Adsi/GetDomainGroupsTree', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AdsiProviderService.prototype.getDomainUsers = function (searchUser) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Adsi/GetDomainUsers', { searchUser: searchUser })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AdsiProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return AdsiProviderService;
}());
angular.module('dataServiceProvider').service('adsiProvider', AdsiProviderService);
var AppDiagnosticProviderService = (function () {
    function AppDiagnosticProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    AppDiagnosticProviderService.prototype.getAppHealth = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/AppDiagnostic/GetAppHealth', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AppDiagnosticProviderService.prototype.getDriveInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/AppDiagnostic/GetDriveInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AppDiagnosticProviderService.prototype.getDatabasesInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/AppDiagnostic/GetDatabasesInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AppDiagnosticProviderService.prototype.isDatabaseAvailable = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/AppDiagnostic/IsDatabaseAvailable', { params: {} })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AppDiagnosticProviderService.prototype.getLicenseInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/AppDiagnostic/GetLicenseInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AppDiagnosticProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return AppDiagnosticProviderService;
}());
angular.module('dataServiceProvider').service('appDiagnosticProvider', AppDiagnosticProviderService);
var AuthenticationConfigurationProviderService = (function () {
    function AuthenticationConfigurationProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    AuthenticationConfigurationProviderService.prototype.getAuthenticationConfiguration = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/AuthenticationConfiguration/GetAuthenticationConfiguration', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AuthenticationConfigurationProviderService.prototype.isAdsiAuthenticationAllowed = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/AuthenticationConfiguration/IsAdsiAuthenticationAllowed', { params: {} })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AuthenticationConfigurationProviderService.prototype.getEnabledAuthenticationTypes = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/AuthenticationConfiguration/GetEnabledAuthenticationTypes', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AuthenticationConfigurationProviderService.prototype.saveAuthenticationConfiguration = function (authenticationConfiguration) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/AuthenticationConfiguration/SaveAuthenticationConfiguration', { authenticationConfiguration: authenticationConfiguration })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AuthenticationConfigurationProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return AuthenticationConfigurationProviderService;
}());
angular.module('dataServiceProvider').service('authenticationConfigurationProvider', AuthenticationConfigurationProviderService);
var AuthenticationProviderService = (function () {
    function AuthenticationProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    AuthenticationProviderService.prototype.signIn = function (login, password, authenticationType, username, roles) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Authentication/SignIn', { login: login, password: password, authenticationType: authenticationType, username: username, roles: roles })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AuthenticationProviderService.prototype.signOut = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Authentication/SignOut', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AuthenticationProviderService.prototype.refreshTokens = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Authentication/RefreshTokens', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AuthenticationProviderService.prototype.getAccessToken = function (login, password, authenticationType) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Authentication/GetAccessToken', { login: login, password: password, authenticationType: authenticationType })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    AuthenticationProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return AuthenticationProviderService;
}());
angular.module('dataServiceProvider').service('authenticationProvider', AuthenticationProviderService);
var CimModelProviderService = (function () {
    function CimModelProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    CimModelProviderService.prototype.getModels = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/CimModel/GetModels', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.canCreateLinkInstance = function (linkUniqueCode, sourceClassInstanceUniqueCode) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/CimModel/CanCreateLinkInstance', { params: { linkUniqueCode: linkUniqueCode, sourceClassInstanceUniqueCode: sourceClassInstanceUniqueCode } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.renameDictionary = function (id, name) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/RenameDictionary', { id: id, name: name })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.addDictionaryProfile = function (id, name) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/AddDictionaryProfile', { id: id, name: name })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.removeDictionaryProfile = function (id) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/RemoveDictionaryProfile', { id: id })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.addDictionaryProfileNode = function (name, profileId, rootNode, nodeId, sourceUniqueClassName, targetUniqueClassName, createGroup, isBackLink) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/AddDictionaryProfileNode', { name: name, profileId: profileId, rootNode: rootNode, nodeId: nodeId, sourceUniqueClassName: sourceUniqueClassName, targetUniqueClassName: targetUniqueClassName, createGroup: createGroup, isBackLink: isBackLink })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.setGroupClassProperty = function (profileId, nodeId) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/SetGroupClassProperty', { profileId: profileId, nodeId: nodeId })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.setShowSelfLinksProperty = function (profileId, nodeId) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/SetShowSelfLinksProperty', { profileId: profileId, nodeId: nodeId })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.removeDictionaryProfileNode = function (profileId, nodeId) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/RemoveDictionaryProfileNode', { profileId: profileId, nodeId: nodeId })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.createClass = function (name, baseClassUniqueCode) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/CreateClass', { name: name, baseClassUniqueCode: baseClassUniqueCode })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.updateClass = function (uniqueCode, name) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/UpdateClass', { uniqueCode: uniqueCode, name: name })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.deleteClass = function (uniqueCode) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/DeleteClass', { uniqueCode: uniqueCode })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.copyClassInstance = function (classInstanceCode) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/CopyClassInstance', { classInstanceCode: classInstanceCode })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.deleteClassInstance = function (uniqueCode) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/DeleteClassInstance', { uniqueCode: uniqueCode })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.createNewLinkInstance = function (linkUniqueCode, sourceClassInstanceUniqueCode, targetClassInstanceUniqueCode, createTransitionLinks) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/CreateNewLinkInstance', { linkUniqueCode: linkUniqueCode, sourceClassInstanceUniqueCode: sourceClassInstanceUniqueCode, targetClassInstanceUniqueCode: targetClassInstanceUniqueCode, createTransitionLinks: createTransitionLinks })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.updateLinkInstance = function (linkUniqueCode, sourceClassInstanceUniqueCode, oldTargetClassInstanceUniqueCode, targetClassInstanceUniqueCode) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/UpdateLinkInstance', { linkUniqueCode: linkUniqueCode, sourceClassInstanceUniqueCode: sourceClassInstanceUniqueCode, oldTargetClassInstanceUniqueCode: oldTargetClassInstanceUniqueCode, targetClassInstanceUniqueCode: targetClassInstanceUniqueCode })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.deleteLinkInstance = function (linkUniqueCode) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/DeleteLinkInstance', { linkUniqueCode: linkUniqueCode })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.isClassHasSelfLink = function (classUniqueCode) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/IsClassHasSelfLink', { classUniqueCode: classUniqueCode })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.createLink = function (name, source, target, type, capacity) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/CreateLink', { name: name, source: source, target: target, type: type, capacity: capacity })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.updateLink = function (uniqueCode, name, target, type, capacity) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/UpdateLink', { uniqueCode: uniqueCode, name: name, target: target, type: type, capacity: capacity })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.deleteLink = function (uniqueCode) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/DeleteLink', { uniqueCode: uniqueCode })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.createAttribute = function (name, classUniqueCode, type) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/CreateAttribute', { name: name, classUniqueCode: classUniqueCode, type: type })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.updateAttribute = function (uniqueCode, name, type) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/UpdateAttribute', { uniqueCode: uniqueCode, name: name, type: type })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.deleteAttribute = function (uniqueCode) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/DeleteAttribute', { uniqueCode: uniqueCode })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.import = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/Import', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.prototype.setAttributeValue = function (attributeUniqueCode, classUniqueCode, value) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CimModel/SetAttributeValue', { attributeUniqueCode: attributeUniqueCode, classUniqueCode: classUniqueCode, value: value })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimModelProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return CimModelProviderService;
}());
angular.module('dataServiceProvider').service('cimModelProvider', CimModelProviderService);
var ClusterServerProviderService = (function () {
    function ClusterServerProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    ClusterServerProviderService.prototype.getServerInfo = function (address) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ClusterServer/GetServerInfo', { params: { address: address } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ClusterServerProviderService.prototype.getServersInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ClusterServer/GetServersInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ClusterServerProviderService.prototype.determineStatus = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ClusterServer/DetermineStatus', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ClusterServerProviderService.prototype.getStatus = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ClusterServer/GetStatus', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ClusterServerProviderService.prototype.isClusteringEnabled = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ClusterServer/IsClusteringEnabled', { params: {} })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ClusterServerProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return ClusterServerProviderService;
}());
angular.module('dataServiceProvider').service('clusterServerProvider', ClusterServerProviderService);
var CoreConfigurationProviderService = (function () {
    function CoreConfigurationProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    CoreConfigurationProviderService.prototype.getCoreConfiguration = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/CoreConfiguration/GetCoreConfiguration', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CoreConfigurationProviderService.prototype.getLanguage = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/CoreConfiguration/GetLanguage', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CoreConfigurationProviderService.prototype.getStartPageUrl = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/CoreConfiguration/GetStartPageUrl', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CoreConfigurationProviderService.prototype.getServerId = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/CoreConfiguration/GetServerId', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CoreConfigurationProviderService.prototype.getApplicationTitle = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/CoreConfiguration/GetApplicationTitle', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CoreConfigurationProviderService.prototype.getVersion = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/CoreConfiguration/GetVersion', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CoreConfigurationProviderService.prototype.getDatabaseRole = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/CoreConfiguration/GetDatabaseRole', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CoreConfigurationProviderService.prototype.saveCoreConfiguration = function (coreConfiguration) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/CoreConfiguration/SaveCoreConfiguration', { coreConfiguration: coreConfiguration })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CoreConfigurationProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return CoreConfigurationProviderService;
}());
angular.module('dataServiceProvider').service('coreConfigurationProvider', CoreConfigurationProviderService);
var ExternalConnectionsProviderService = (function () {
    function ExternalConnectionsProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    ExternalConnectionsProviderService.prototype.getAll = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ExternalConnections/GetAll', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ExternalConnectionsProviderService.prototype.get = function (types) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ExternalConnections/Get', { params: { types: types } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ExternalConnectionsProviderService.prototype.createDefaultConnection = function (name) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ExternalConnections/CreateDefaultConnection', { params: { name: name } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ExternalConnectionsProviderService.prototype.hasOracleProvider = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ExternalConnections/HasOracleProvider', { params: {} })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ExternalConnectionsProviderService.prototype.resetState = function (guid, settingsIdx) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ExternalConnections/ResetState', { params: { guid: guid, settingsIdx: settingsIdx } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ExternalConnectionsProviderService.prototype.createConnection = function (connectionSettings) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ExternalConnections/CreateConnection', { connectionSettings: connectionSettings })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ExternalConnectionsProviderService.prototype.saveChange = function (connectionSettings) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ExternalConnections/SaveChange', { connectionSettings: connectionSettings })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ExternalConnectionsProviderService.prototype.deleteConnection = function (connectionSettings) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ExternalConnections/DeleteConnection', { connectionSettings: connectionSettings })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ExternalConnectionsProviderService.prototype.ping = function (externalConnectionSettings, specializedSettingsIndex) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ExternalConnections/Ping', { externalConnectionSettings: externalConnectionSettings, specializedSettingsIndex: specializedSettingsIndex })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ExternalConnectionsProviderService.prototype.importExternalConnections = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ExternalConnections/ImportExternalConnections', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ExternalConnectionsProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return ExternalConnectionsProviderService;
}());
angular.module('dataServiceProvider').service('externalConnectionsProvider', ExternalConnectionsProviderService);
var JobSchedulerProviderService = (function () {
    function JobSchedulerProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    JobSchedulerProviderService.prototype.getJobsInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/JobScheduler/GetJobsInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    JobSchedulerProviderService.prototype.isJobSchedulerEnabled = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/JobScheduler/IsJobSchedulerEnabled', { params: {} })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    JobSchedulerProviderService.prototype.executeJob = function (jobId) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/JobScheduler/ExecuteJob', { jobId: jobId })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    JobSchedulerProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return JobSchedulerProviderService;
}());
angular.module('dataServiceProvider').service('jobSchedulerProvider', JobSchedulerProviderService);
var LicenseProviderService = (function () {
    function LicenseProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    LicenseProviderService.prototype.getLicense = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/License/GetLicense', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    LicenseProviderService.prototype.getOwnerName = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/License/GetOwnerName', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    LicenseProviderService.prototype.getSource = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/License/GetSource', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    LicenseProviderService.prototype.getLicenseSettingsInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/License/GetLicenseSettingsInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    LicenseProviderService.prototype.activateLicense = function (licenseKey) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/License/ActivateLicense', { licenseKey: licenseKey })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    LicenseProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return LicenseProviderService;
}());
angular.module('dataServiceProvider').service('licenseProvider', LicenseProviderService);
var MailProviderService = (function () {
    function MailProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    MailProviderService.prototype.getAllMails = function (startDate, endDate) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/Mail/GetAllMails', { params: { startDate: startDate, endDate: endDate } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    MailProviderService.prototype.getMailClientConfiguration = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/Mail/GetMailClientConfiguration', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    MailProviderService.prototype.isMailEnabled = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/Mail/IsMailEnabled', { params: {} })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    MailProviderService.prototype.connectToServer = function (host, port) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Mail/ConnectToServer', { host: host, port: port })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    MailProviderService.prototype.saveMailClientConfiguration = function (mailConfiguration) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Mail/SaveMailClientConfiguration', { mailConfiguration: mailConfiguration })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    MailProviderService.prototype.deleteMail = function (mail) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Mail/DeleteMail', { mail: mail })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    MailProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return MailProviderService;
}());
angular.module('dataServiceProvider').service('mailProvider', MailProviderService);
var OpcConnectionProviderService = (function () {
    function OpcConnectionProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    OpcConnectionProviderService.prototype.checkOpcTagAddress = function (tag, connectionGuid) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/OpcConnection/CheckOpcTagAddress', { params: { tag: tag, connectionGuid: connectionGuid } })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OpcConnectionProviderService.prototype.getOpcUaServers = function (explorerServerEndpoint) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/OpcConnection/GetOpcUaServers', { params: { explorerServerEndpoint: explorerServerEndpoint } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OpcConnectionProviderService.prototype.getOpcTreeNodes = function (connectionGuid, parentId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/OpcConnection/GetOpcTreeNodes', { params: { connectionGuid: connectionGuid, parentId: parentId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OpcConnectionProviderService.prototype.getOpcDaHdaServers = function (host, opcStandard) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OpcConnection/GetOpcDaHdaServers', { host: host, opcStandard: opcStandard })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OpcConnectionProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return OpcConnectionProviderService;
}());
angular.module('dataServiceProvider').service('opcConnectionProvider', OpcConnectionProviderService);
var OperationTimeConfigurationProviderService = (function () {
    function OperationTimeConfigurationProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    OperationTimeConfigurationProviderService.prototype.getOperationTimeConfiguration = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/OperationTimeConfiguration/GetOperationTimeConfiguration', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeConfigurationProviderService.prototype.saveOperationTimeConfiguration = function (configuration) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeConfiguration/SaveOperationTimeConfiguration', { configuration: configuration })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeConfigurationProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return OperationTimeConfigurationProviderService;
}());
angular.module('dataServiceProvider').service('operationTimeConfigurationProvider', OperationTimeConfigurationProviderService);
var OperationTimeParameterProviderService = (function () {
    function OperationTimeParameterProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    OperationTimeParameterProviderService.prototype.get = function (parameterGuid) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/OperationTimeParameter/Get', { params: { parameterGuid: parameterGuid } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.getAll = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/OperationTimeParameter/GetAll', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.getAllShortInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/OperationTimeParameter/GetAllShortInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.getAllNames = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/OperationTimeParameter/GetAllNames', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.getAllChanges = function (startDate, endDate) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/OperationTimeParameter/GetAllChanges', { params: { startDate: startDate, endDate: endDate } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.create = function (name) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeParameter/Create', { name: name })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.save = function (operationTimeParameterDTO) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeParameter/Save', { operationTimeParameterDTO: operationTimeParameterDTO })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.delete = function (operationTimeParameterDTO) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeParameter/Delete', { operationTimeParameterDTO: operationTimeParameterDTO })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.recalculate = function (parameterId, timeInterval) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeParameter/Recalculate', { parameterId: parameterId, timeInterval: timeInterval })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.calculate = function (parameterId, timeInterval) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeParameter/Calculate', { parameterId: parameterId, timeInterval: timeInterval })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.isAlgorithmCorrect = function (parameter) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeParameter/IsAlgorithmCorrect', { parameter: parameter })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.getDeviceStateInfo = function (filter) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeParameter/GetDeviceStateInfo', { filter: filter })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.getDiagramJsonOptions = function (filter) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeParameter/GetDiagramJsonOptions', { filter: filter })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.prototype.checkTag = function (algorithmParameterCross) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeParameter/CheckTag', { algorithmParameterCross: algorithmParameterCross })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeParameterProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return OperationTimeParameterProviderService;
}());
angular.module('dataServiceProvider').service('operationTimeParameterProvider', OperationTimeParameterProviderService);
var OperationTimeRecordProviderService = (function () {
    function OperationTimeRecordProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    OperationTimeRecordProviderService.prototype.hasRecords = function (deviceId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/OperationTimeRecord/HasRecords', { params: { deviceId: deviceId } })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeRecordProviderService.prototype.insert = function (record) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeRecord/Insert', { record: record })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeRecordProviderService.prototype.update = function (record) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeRecord/Update', { record: record })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeRecordProviderService.prototype.delete = function (record) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/OperationTimeRecord/Delete', { record: record })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    OperationTimeRecordProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return OperationTimeRecordProviderService;
}());
angular.module('dataServiceProvider').service('operationTimeRecordProvider', OperationTimeRecordProviderService);
var PermissionProviderService = (function () {
    function PermissionProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    PermissionProviderService.prototype.getPermissionGroups = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/Permission/GetPermissionGroups', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    PermissionProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return PermissionProviderService;
}());
angular.module('dataServiceProvider').service('permissionProvider', PermissionProviderService);
var PrintProviderService = (function () {
    function PrintProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    PrintProviderService.prototype.getPaperSizes = function (printerName) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/Print/GetPaperSizes', { params: { printerName: printerName } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    PrintProviderService.prototype.getPrinterNames = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/Print/GetPrinterNames', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    PrintProviderService.prototype.print = function (pdfFileData, printSettings) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Print/Print', { pdfFileData: pdfFileData, printSettings: printSettings })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    PrintProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return PrintProviderService;
}());
angular.module('dataServiceProvider').service('printProvider', PrintProviderService);
var ReportCalculationProviderService = (function () {
    function ReportCalculationProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    ReportCalculationProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return ReportCalculationProviderService;
}());
angular.module('dataServiceProvider').service('reportCalculationProvider', ReportCalculationProviderService);
var ReportConfigurationProviderService = (function () {
    function ReportConfigurationProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    ReportConfigurationProviderService.prototype.getReportConfiguration = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportConfiguration/GetReportConfiguration', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportConfigurationProviderService.prototype.saveReportConfiguration = function (configuration) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportConfiguration/SaveReportConfiguration', { configuration: configuration })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportConfigurationProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return ReportConfigurationProviderService;
}());
angular.module('dataServiceProvider').service('reportConfigurationProvider', ReportConfigurationProviderService);
var ReportProviderService = (function () {
    function ReportProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    ReportProviderService.prototype.getReportTree = function (templateGuid) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/Report/GetReportTree', { params: { templateGuid: templateGuid } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportProviderService.prototype.sendReport = function (reportId, sendToEmailByEventSettings, templateGuid) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Report/SendReport', { reportId: reportId, sendToEmailByEventSettings: sendToEmailByEventSettings, templateGuid: templateGuid })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportProviderService.prototype.sendReportHtml = function (reportName, reportStartDate, reportEndDate, exportFileNameTemplate, html, sendToEmailByEventSettings, templateGuid) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Report/SendReportHtml', { reportName: reportName, reportStartDate: reportStartDate, reportEndDate: reportEndDate, exportFileNameTemplate: exportFileNameTemplate, html: html, sendToEmailByEventSettings: sendToEmailByEventSettings, templateGuid: templateGuid })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportProviderService.prototype.unlockReport = function (reportId, templateGuid) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Report/UnlockReport', { reportId: reportId, templateGuid: templateGuid })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportProviderService.prototype.lockReport = function (reportId, templateGuid) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Report/LockReport', { reportId: reportId, templateGuid: templateGuid })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportProviderService.prototype.enableRules = function (reportId, enabledRulesIndexes) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Report/EnableRules', { reportId: reportId, enabledRulesIndexes: enabledRulesIndexes })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportProviderService.prototype.hasSignedReports = function (userLogin) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Report/HasSignedReports', { userLogin: userLogin })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportProviderService.prototype.deleteReports = function (reportsDeleteInfo, templateGuid) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Report/DeleteReports', { reportsDeleteInfo: reportsDeleteInfo, templateGuid: templateGuid })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return ReportProviderService;
}());
angular.module('dataServiceProvider').service('reportProvider', ReportProviderService);
var ReportExportProviderService = (function () {
    function ReportExportProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    ReportExportProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return ReportExportProviderService;
}());
angular.module('dataServiceProvider').service('reportExportProvider', ReportExportProviderService);
var ReportFormulasProviderService = (function () {
    function ReportFormulasProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    ReportFormulasProviderService.prototype.getAll = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportFormulas/GetAll', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportFormulasProviderService.prototype.get = function (id) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportFormulas/Get', { params: { id: id } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportFormulasProviderService.prototype.getFormulasInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportFormulas/GetFormulasInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportFormulasProviderService.prototype.getFormulaUsage = function (formulaId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportFormulas/GetFormulaUsage', { params: { formulaId: formulaId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportFormulasProviderService.prototype.createDefaultFormula = function (name) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportFormulas/CreateDefaultFormula', { name: name })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportFormulasProviderService.prototype.create = function (reportFormula) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportFormulas/Create', { reportFormula: reportFormula })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportFormulasProviderService.prototype.update = function (reportFormula) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportFormulas/Update', { reportFormula: reportFormula })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportFormulasProviderService.prototype.delete = function (formulaIds) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportFormulas/Delete', { formulaIds: formulaIds })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportFormulasProviderService.prototype.import = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportFormulas/Import', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportFormulasProviderService.prototype.isFormulaValid = function (reportFormula) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportFormulas/IsFormulaValid', { reportFormula: reportFormula })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportFormulasProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return ReportFormulasProviderService;
}());
angular.module('dataServiceProvider').service('reportFormulasProvider', ReportFormulasProviderService);
var ReportTemplateProviderService = (function () {
    function ReportTemplateProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    ReportTemplateProviderService.prototype.getPredefinedValuesHashCode = function (predefinedValuesJson) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportTemplate/GetPredefinedValuesHashCode', { params: { predefinedValuesJson: predefinedValuesJson } })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTemplateProviderService.prototype.getAllReportTemplatesShortInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportTemplate/GetAllReportTemplatesShortInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTemplateProviderService.prototype.getAllReportTemplatesCreationInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportTemplate/GetAllReportTemplatesCreationInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTemplateProviderService.prototype.getAllReportTemplatesCalculationInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportTemplate/GetAllReportTemplatesCalculationInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTemplateProviderService.prototype.getDemoReportTemplatesImportInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportTemplate/GetDemoReportTemplatesImportInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTemplateProviderService.prototype.deleteReportTemplate = function (reportTemplateBaseInfo) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportTemplate/DeleteReportTemplate', { reportTemplateBaseInfo: reportTemplateBaseInfo })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTemplateProviderService.prototype.getReportTemplatesImportInfo = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportTemplate/GetReportTemplatesImportInfo', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTemplateProviderService.prototype.getExtrenalConnectionUsingTemplates = function (connectionGuid) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportTemplate/GetExtrenalConnectionUsingTemplates', { connectionGuid: connectionGuid })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTemplateProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return ReportTemplateProviderService;
}());
angular.module('dataServiceProvider').service('reportTemplateProvider', ReportTemplateProviderService);
var ReportTreeViewerProviderService = (function () {
    function ReportTreeViewerProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    ReportTreeViewerProviderService.prototype.getTree = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/ReportTreeViewer/GetTree', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTreeViewerProviderService.prototype.getValues = function (jsonParameters, startTime, endTime) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/ReportTreeViewer/GetValues', { jsonParameters: jsonParameters, startTime: startTime, endTime: endTime })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTreeViewerProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return ReportTreeViewerProviderService;
}());
angular.module('dataServiceProvider').service('reportTreeViewerProvider', ReportTreeViewerProviderService);
var RoleProviderService = (function () {
    function RoleProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    RoleProviderService.prototype.getAll = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/Role/GetAll', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    RoleProviderService.prototype.create = function (name) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Role/Create', { name: name })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    RoleProviderService.prototype.update = function (roleDto) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Role/Update', { roleDto: roleDto })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    RoleProviderService.prototype.delete = function (roleDto) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/Role/Delete', { roleDto: roleDto })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    RoleProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return RoleProviderService;
}());
angular.module('dataServiceProvider').service('roleProvider', RoleProviderService);
var ServerSettingsProviderService = (function () {
    function ServerSettingsProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    ServerSettingsProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return ServerSettingsProviderService;
}());
angular.module('dataServiceProvider').service('serverSettingsProvider', ServerSettingsProviderService);
var SwitchoverFormAlarmsProviderService = (function () {
    function SwitchoverFormAlarmsProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormAlarmsProviderService.prototype.getAllAlarms = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormAlarms/GetAllAlarms', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormAlarmsProviderService.prototype.getFormAlarms = function (formId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormAlarms/GetFormAlarms', { params: { formId: formId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormAlarmsProviderService.prototype.getTemplateAlarms = function (templateId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormAlarms/GetTemplateAlarms', { params: { templateId: templateId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormAlarmsProviderService.prototype.getTemplateNames = function (alarmId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormAlarms/GetTemplateNames', { params: { alarmId: alarmId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormAlarmsProviderService.prototype.createAlarm = function (alarm) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormAlarms/CreateAlarm', { alarm: alarm })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormAlarmsProviderService.prototype.updateAlarm = function (alarm) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormAlarms/UpdateAlarm', { alarm: alarm })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormAlarmsProviderService.prototype.deleteAlarm = function (id) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormAlarms/DeleteAlarm', { id: id })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormAlarmsProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormAlarmsProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormAlarmsProvider', SwitchoverFormAlarmsProviderService);
var SwitchoverFormConfigurationProviderService = (function () {
    function SwitchoverFormConfigurationProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormConfigurationProviderService.prototype.getSwitchoverFormConfiguration = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormConfiguration/GetSwitchoverFormConfiguration', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormConfigurationProviderService.prototype.getPreferredSigners = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormConfiguration/GetPreferredSigners', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormConfigurationProviderService.prototype.saveSwitchoverFormConfiguration = function (configuration) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormConfiguration/SaveSwitchoverFormConfiguration', { configuration: configuration })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormConfigurationProviderService.prototype.setPreferredSigners = function (signers) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormConfiguration/SetPreferredSigners', { signers: signers })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormConfigurationProviderService.prototype.isTagExists = function (tagAddress, source) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormConfiguration/IsTagExists', { tagAddress: tagAddress, source: source })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormConfigurationProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormConfigurationProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormConfigurationProvider', SwitchoverFormConfigurationProviderService);
var SwitchoverFormProviderService = (function () {
    function SwitchoverFormProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormProviderService.prototype.getSwitchoverForm = function (id) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverForm/GetSwitchoverForm', { params: { id: id } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.getAllNames = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverForm/GetAllNames', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.getSerialNumber = function (formName) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverForm/GetSerialNumber', { params: { formName: formName } })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.getOpenFormDescription = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverForm/GetOpenFormDescription', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.isExistsOpenedSwitchoverForm = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverForm/IsExistsOpenedSwitchoverForm', { params: {} })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.getSwitchoverFormsInfo = function (filter) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/GetSwitchoverFormsInfo', { filter: filter })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.getHtml = function (id) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/GetHtml', { id: id })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.create = function (templateId, serialNumber, signers, conditions) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/Create', { templateId: templateId, serialNumber: serialNumber, signers: signers, conditions: conditions })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.addSigners = function (id, signers) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/AddSigners', { id: id, signers: signers })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.executeOperation = function (formId, formName, formSerial, operationId, operationOrderNumber) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/ExecuteOperation', { formId: formId, formName: formName, formSerial: formSerial, operationId: operationId, operationOrderNumber: operationOrderNumber })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.verifyCondition = function (formId, formName, formSerial, conditionId, conditionOrderNumber) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/VerifyCondition', { formId: formId, formName: formName, formSerial: formSerial, conditionId: conditionId, conditionOrderNumber: conditionOrderNumber })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.verifyAutomaticCondition = function (formName, formSerial, condition, alarms, conditionOrderNumber) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/VerifyAutomaticCondition', { formName: formName, formSerial: formSerial, condition: condition, alarms: alarms, conditionOrderNumber: conditionOrderNumber })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.executeOperationManual = function (formId, formName, formSerial, operationId, operationOrderNumber, isNeedCheckAlarms) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/ExecuteOperationManual', { formId: formId, formName: formName, formSerial: formSerial, operationId: operationId, operationOrderNumber: operationOrderNumber, isNeedCheckAlarms: isNeedCheckAlarms })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.verifyConditionManual = function (formId, formName, formSerial, conditionId, conditionOrderNumber, isNeedCheckAlarms) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/VerifyConditionManual', { formId: formId, formName: formName, formSerial: formSerial, conditionId: conditionId, conditionOrderNumber: conditionOrderNumber, isNeedCheckAlarms: isNeedCheckAlarms })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.cancelManualOperationExecution = function (formName, formSerial, operationId, operationOrderNumber) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/CancelManualOperationExecution', { formName: formName, formSerial: formSerial, operationId: operationId, operationOrderNumber: operationOrderNumber })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.cancelManualConditionVerification = function (formName, formSerial, conditionId, conditionOrderNumber) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/CancelManualConditionVerification', { formName: formName, formSerial: formSerial, conditionId: conditionId, conditionOrderNumber: conditionOrderNumber })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.close = function (id, formName, formSerial, closeDate) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/Close', { id: id, formName: formName, formSerial: formSerial, closeDate: closeDate })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.send = function (id, sendingInfo) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/Send', { id: id, sendingInfo: sendingInfo })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.delete = function (id, formName, formSerial) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/Delete', { id: id, formName: formName, formSerial: formSerial })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.prototype.stop = function (id, formName, formSerial, stopInfo) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverForm/Stop', { id: id, formName: formName, formSerial: formSerial, stopInfo: stopInfo })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormProvider', SwitchoverFormProviderService);
var SwitchoverFormExportProviderService = (function () {
    function SwitchoverFormExportProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormExportProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormExportProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormExportProvider', SwitchoverFormExportProviderService);
var SwitchoverFormTemplateAttachmentProviderService = (function () {
    function SwitchoverFormTemplateAttachmentProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormTemplateAttachmentProviderService.prototype.getAttachments = function (templateId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplateAttachment/GetAttachments', { params: { templateId: templateId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateAttachmentProviderService.prototype.importAttachments = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplateAttachment/ImportAttachments', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateAttachmentProviderService.prototype.deleteAttachment = function (id) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplateAttachment/DeleteAttachment', { id: id })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateAttachmentProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormTemplateAttachmentProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormTemplateAttachmentProvider', SwitchoverFormTemplateAttachmentProviderService);
var SwitchoverFormTemplateProviderService = (function () {
    function SwitchoverFormTemplateProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormTemplateProviderService.prototype.getAllSwitchoverFormTemplatesShortInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/GetAllSwitchoverFormTemplatesShortInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.getAllSwitchoverFormTemplatesShortInfoWithIsTypical = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/GetAllSwitchoverFormTemplatesShortInfoWithIsTypical', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.getSwitchoverFormTemplate = function (id) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/GetSwitchoverFormTemplate', { params: { id: id } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.getSignerAppointments = function (id) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/GetSignerAppointments', { params: { id: id } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.getHtml = function (id) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/GetHtml', { params: { id: id } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.getPreview = function (id) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/GetPreview', { params: { id: id } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.getFormConditions = function (templateId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/GetFormConditions', { params: { templateId: templateId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.getFormAlarms = function (templateId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/GetFormAlarms', { params: { templateId: templateId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.create = function (name, chapterName) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/Create', { name: name, chapterName: chapterName })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.save = function (template) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/Save', { template: template })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.updateGeneralSettings = function (templateId, templateName, chapter, description) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/UpdateGeneralSettings', { templateId: templateId, templateName: templateName, chapter: chapter, description: description })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.copy = function (name, parentId, fromOperationNumber) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/Copy', { name: name, parentId: parentId, fromOperationNumber: fromOperationNumber })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.send = function (templateId, sendingInfo) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/Send', { templateId: templateId, sendingInfo: sendingInfo })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.setTypical = function (templateId, templateName) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/SetTypical', { templateId: templateId, templateName: templateName })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.delete = function (id, name) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/Delete', { id: id, name: name })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.isExists = function (templateName) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/IsExists', { templateName: templateName })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.prototype.isExistsExcept = function (templateName, exceptTemplateId) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplate/IsExistsExcept', { templateName: templateName, exceptTemplateId: exceptTemplateId })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormTemplateProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormTemplateProvider', SwitchoverFormTemplateProviderService);
var SwitchoverFormTemplateExportProviderService = (function () {
    function SwitchoverFormTemplateExportProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormTemplateExportProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormTemplateExportProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormTemplateExportProvider', SwitchoverFormTemplateExportProviderService);
var SwitchoverFormTemplateImportProviderService = (function () {
    function SwitchoverFormTemplateImportProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormTemplateImportProviderService.prototype.getDocxImportInfo = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplateImport/GetDocxImportInfo', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateImportProviderService.prototype.getJsonImportInfo = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplateImport/GetJsonImportInfo', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateImportProviderService.prototype.importFromJson = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplateImport/ImportFromJson', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateImportProviderService.prototype.importFromDocx = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTemplateImport/ImportFromDocx', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTemplateImportProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormTemplateImportProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormTemplateImportProvider', SwitchoverFormTemplateImportProviderService);
var SwitchoverFormTypicalConditionsProviderService = (function () {
    function SwitchoverFormTypicalConditionsProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormTypicalConditionsProviderService.prototype.getAllTypicalConditions = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalConditions/GetAllTypicalConditions', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalConditionsProviderService.prototype.getTemplateNames = function (conditionId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalConditions/GetTemplateNames', { params: { conditionId: conditionId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalConditionsProviderService.prototype.createTypicalCondition = function (condition) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalConditions/CreateTypicalCondition', { condition: condition })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalConditionsProviderService.prototype.updateTypicalCondition = function (condition) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalConditions/UpdateTypicalCondition', { condition: condition })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalConditionsProviderService.prototype.deleteTypicalCondition = function (id) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalConditions/DeleteTypicalCondition', { id: id })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalConditionsProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormTypicalConditionsProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormTypicalConditionsProvider', SwitchoverFormTypicalConditionsProviderService);
var SwitchoverFormTypicalConditionsExportProviderService = (function () {
    function SwitchoverFormTypicalConditionsExportProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormTypicalConditionsExportProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormTypicalConditionsExportProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormTypicalConditionsExportProvider', SwitchoverFormTypicalConditionsExportProviderService);
var SwitchoverFormTypicalConditionsImportProviderService = (function () {
    function SwitchoverFormTypicalConditionsImportProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormTypicalConditionsImportProviderService.prototype.getJsonImportInfo = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalConditionsImport/GetJsonImportInfo', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalConditionsImportProviderService.prototype.getDocxImportInfo = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalConditionsImport/GetDocxImportInfo', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalConditionsImportProviderService.prototype.importFromJson = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalConditionsImport/ImportFromJson', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalConditionsImportProviderService.prototype.importFromDocx = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalConditionsImport/ImportFromDocx', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalConditionsImportProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormTypicalConditionsImportProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormTypicalConditionsImportProvider', SwitchoverFormTypicalConditionsImportProviderService);
var SwitchoverFormTypicalOperationsProviderService = (function () {
    function SwitchoverFormTypicalOperationsProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormTypicalOperationsProviderService.prototype.getAllTypicalOperations = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalOperations/GetAllTypicalOperations', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalOperationsProviderService.prototype.getTemplateNames = function (operationId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalOperations/GetTemplateNames', { params: { operationId: operationId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalOperationsProviderService.prototype.createTypicalOperation = function (operation) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalOperations/CreateTypicalOperation', { operation: operation })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalOperationsProviderService.prototype.updateTypicalOperation = function (operation) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalOperations/UpdateTypicalOperation', { operation: operation })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalOperationsProviderService.prototype.deleteTypicalOperation = function (id) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalOperations/DeleteTypicalOperation', { id: id })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalOperationsProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormTypicalOperationsProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormTypicalOperationsProvider', SwitchoverFormTypicalOperationsProviderService);
var SwitchoverFormTypicalOperationsExportProviderService = (function () {
    function SwitchoverFormTypicalOperationsExportProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormTypicalOperationsExportProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormTypicalOperationsExportProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormTypicalOperationsExportProvider', SwitchoverFormTypicalOperationsExportProviderService);
var SwitchoverFormTypicalOperationsImportProviderService = (function () {
    function SwitchoverFormTypicalOperationsImportProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SwitchoverFormTypicalOperationsImportProviderService.prototype.getJsonImportInfo = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalOperationsImport/GetJsonImportInfo', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalOperationsImportProviderService.prototype.getDocxImportInfo = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalOperationsImport/GetDocxImportInfo', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalOperationsImportProviderService.prototype.importFromJson = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalOperationsImport/ImportFromJson', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalOperationsImportProviderService.prototype.importFromDocx = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/SwitchoverFormTypicalOperationsImport/ImportFromDocx', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SwitchoverFormTypicalOperationsImportProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SwitchoverFormTypicalOperationsImportProviderService;
}());
angular.module('dataServiceProvider').service('switchoverFormTypicalOperationsImportProvider', SwitchoverFormTypicalOperationsImportProviderService);
var SystemLogProviderService = (function () {
    function SystemLogProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    SystemLogProviderService.prototype.getSystemLogs = function (startDate, endDate) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SystemLog/GetSystemLogs', { params: { startDate: startDate, endDate: endDate } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SystemLogProviderService.prototype.getSystemLogChanges = function (logId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SystemLog/GetSystemLogChanges', { params: { logId: logId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SystemLogProviderService.prototype.getSystemLogsWithSubstring = function (description) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SystemLog/GetSystemLogsWithSubstring', { params: { description: description } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SystemLogProviderService.prototype.getSystemLogTagInfo = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/SystemLog/GetSystemLogTagInfo', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    SystemLogProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return SystemLogProviderService;
}());
angular.module('dataServiceProvider').service('systemLogProvider', SystemLogProviderService);
var TimezoneProviderService = (function () {
    function TimezoneProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    TimezoneProviderService.prototype.getAllTimezones = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/Timezone/GetAllTimezones', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    TimezoneProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return TimezoneProviderService;
}());
angular.module('dataServiceProvider').service('timezoneProvider', TimezoneProviderService);
var UserProviderService = (function () {
    function UserProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    UserProviderService.prototype.getRegularUsers = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/User/GetRegularUsers', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserProviderService.prototype.getAll = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/User/GetAll', { params: {} })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserProviderService.prototype.get = function (userId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/User/Get', { params: { userId: userId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserProviderService.prototype.getUserPermissions = function (userId) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/User/GetUserPermissions', { params: { userId: userId } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserProviderService.prototype.create = function (user) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/User/Create', { user: user })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserProviderService.prototype.updatePassword = function (userChangePasswordDto) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/User/UpdatePassword', { userChangePasswordDto: userChangePasswordDto })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserProviderService.prototype.update = function (user) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/User/Update', { user: user })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserProviderService.prototype.delete = function (userId) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/User/Delete', { userId: userId })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return UserProviderService;
}());
angular.module('dataServiceProvider').service('userProvider', UserProviderService);
var UserSessionProviderService = (function () {
    function UserSessionProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    UserSessionProviderService.prototype.getUsers = function (location) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/UserSession/GetUsers', { location: location })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserSessionProviderService.prototype.updateUserSession = function (newUrl, oldUrl) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/UserSession/UpdateUserSession', { newUrl: newUrl, oldUrl: oldUrl })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserSessionProviderService.prototype.removeUserSession = function (url) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/UserSession/RemoveUserSession', { url: url })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserSessionProviderService.prototype.removeAllUserSessions = function () {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/UserSession/RemoveAllUserSessions', {})
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserSessionProviderService.prototype.removeAllUserSessionsByUserGuid = function (userGuid) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/UserSession/RemoveAllUserSessionsByUserGuid', { userGuid: userGuid })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    UserSessionProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return UserSessionProviderService;
}());
angular.module('dataServiceProvider').service('userSessionProvider', UserSessionProviderService);
var WinCCOAProviderService = (function () {
    function WinCCOAProviderService(http, clientSettings, q) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.q = q;
    }
    WinCCOAProviderService.prototype.updateCnsTreeNodes = function (connectionGuid) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/WinCCOA/UpdateCnsTreeNodes', { params: { connectionGuid: connectionGuid } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    WinCCOAProviderService.prototype.updateParaTreeNodes = function (connectionGuid) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/WinCCOA/UpdateParaTreeNodes', { params: { connectionGuid: connectionGuid } })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    WinCCOAProviderService.prototype.isDataPointExists = function (tagAddress, connectionGuid) {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/WinCCOA/IsDataPointExists', { params: { tagAddress: tagAddress, connectionGuid: connectionGuid } })
            .then(function (response) {
            deferred.resolve(JSON.parse(response.data));
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    WinCCOAProviderService.prototype.getCnsTreeNodes = function (connectionGuid, searchText) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/WinCCOA/GetCnsTreeNodes', { connectionGuid: connectionGuid, searchText: searchText })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    WinCCOAProviderService.prototype.getParaTreeNodes = function (connectionGuid, parentId, searchText, isShowDescription) {
        var deferred = this.q.defer();
        this.http.post(this.clientSettings.getServerInstance() + '/WinCCOA/GetParaTreeNodes', { connectionGuid: connectionGuid, parentId: parentId, searchText: searchText, isShowDescription: isShowDescription })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    WinCCOAProviderService.$inject = ['$http', 'clientSettings', '$q'];
    return WinCCOAProviderService;
}());
angular.module('dataServiceProvider').service('winCCOAProvider', WinCCOAProviderService);
