var DateExternalFormatParser = (function () {
    function DateExternalFormatParser() {
    }
    DateExternalFormatParser.fromJson = function (json) {
        if (_.isUndefined(json) || _.isNull(json)) {
            return json;
        }
        if (typeof json === 'string' && Date.isSMSExternalFormat(json)) {
            return Date.fromSMSExternalFormat(json);
        }
        for (var key in json) {
            if (json[key]) {
                var value = json[key];
                if (_.isArray(value)) {
                    _.forEach(value, function (item) {
                        DateExternalFormatParser.fromJson(item);
                    });
                }
                else if (typeof value === 'object') {
                    DateExternalFormatParser.fromJson(value);
                }
                else if (typeof value === 'string' && Date.isSMSExternalFormat(value)) {
                    json[key] = Date.fromSMSExternalFormat(value);
                }
            }
        }
        return json;
    };
    DateExternalFormatParser.deepTransformDates = function (object) {
        var _this = this;
        if (object instanceof Date) {
            return this.toJson(object);
        }
        if (Array.isArray(object)) {
            return object.map(function (element) { return _this.deepTransformDates(element); });
        }
        if (object !== null && typeof object === 'object') {
            return Object.fromEntries(Object.entries(object).map(function (_a) {
                var key = _a[0], value = _a[1];
                return [key, _this.deepTransformDates(value)];
            }));
        }
        return object;
    };
    DateExternalFormatParser.toJson = function (date) {
        var years = date.getFullYear();
        var yearsToStr = years.toString();
        if (years < 10) {
            yearsToStr = '000' + years;
        }
        else if (years < 100) {
            yearsToStr = '00' + years;
        }
        else if (years < 1000) {
            yearsToStr = '0' + years;
        }
        return (yearsToStr +
            '.' +
            DateExternalFormatParser.pad(date.getMonth() + 1) +
            '.' +
            DateExternalFormatParser.pad(date.getDate()) +
            '.' +
            DateExternalFormatParser.pad(date.getHours()) +
            '.' +
            DateExternalFormatParser.pad(date.getMinutes()) +
            '.' +
            DateExternalFormatParser.pad(date.getSeconds()));
    };
    DateExternalFormatParser.pad = function (d) {
        return d < 10 ? '0' + d.toString() : d.toString();
    };
    return DateExternalFormatParser;
}());
