var PrintService = (function () {
    function PrintService($window, $modal, $http, clientSettings, browserInfoProvider, notificationService, language) {
        this.$window = $window;
        this.$modal = $modal;
        this.$http = $http;
        this.clientSettings = clientSettings;
        this.browserInfoProvider = browserInfoProvider;
        this.notificationService = notificationService;
        this.language = language;
    }
    PrintService.prototype.printPdf = function (pdfFileUrl, params) {
        var _this = this;
        if (params === void 0) { params = undefined; }
        if (this.browserInfoProvider.canPrint()) {
            var url = this.clientSettings.getServerInstance() + pdfFileUrl;
            var options = { responseType: 'blob' };
            var request = _.isDefined(params)
                ? this.$http.post(url, params, options)
                : this.$http.get(url, options);
            request.then(function (fileData) {
                var url = URL.createObjectURL(fileData.data);
                var frame = angular.element('<iframe style="display:none" src=' + url + '></iframe>')[0];
                frame.onload = function () {
                    _this.$window.onfocus = function () {
                        URL.revokeObjectURL(url);
                        frame.remove();
                        _this.$window.onfocus = null;
                    };
                    frame.contentWindow.focus();
                    frame.contentWindow.print();
                };
                angular.element('body').append(frame);
            });
        }
        else {
            this.$modal.open({
                templateUrl: 'ng1/dist/src/_angular/_services/printService/PrintModal.html',
                controller: 'printModalCtrl',
                backdrop: 'static',
                resolve: {
                    pdfFileUrl: function () { return pdfFileUrl; },
                    params: function () { return params; }
                }
            }).result.then(function () {
                _this.notificationService.showMessage(_this.language.getElementValue('documentSentToPrintSuccessfullyMsg'));
            }, function () { });
        }
    };
    PrintService.$inject = [
        '$window',
        '$modal',
        '$http',
        'clientSettings',
        'browserInfoProvider',
        'notificationService',
        'language'
    ];
    return PrintService;
}());
app.service('printService', PrintService);
