var PrintModalCtrl = (function () {
    function PrintModalCtrl($scope, $http, $modalInstance, printProvider, language, notificationService, clientSettings, pdfFileUrl, params) {
        if (params === void 0) { params = undefined; }
        var _this = this;
        this.$scope = $scope;
        this.$http = $http;
        this.$modalInstance = $modalInstance;
        this.printProvider = printProvider;
        this.language = language;
        this.notificationService = notificationService;
        this.clientSettings = clientSettings;
        this.pdfFileUrl = pdfFileUrl;
        this.params = params;
        this.printerNames = [];
        this.paperSizes = [];
        this.copiesAmount = 1;
        this.$scope.ctrl = this;
        printProvider.getPrinterNames()
            .then(function (printerNames) {
            _this.printerNames = printerNames;
            _this.selectedPrinter = _.first(_this.printerNames);
            _this.getPaperSizes(_this.selectedPrinter);
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    }
    PrintModalCtrl.prototype.ok = function () {
        var _this = this;
        var printSettings = {
            printerName: this.selectedPrinter,
            paperSize: this.selectedPaperSize,
            copiesAmount: this.copiesAmount
        };
        var url = this.clientSettings.getServerInstance() + this.pdfFileUrl;
        var options = { responseType: 'blob' };
        var request = _.isDefined(this.params)
            ? this.$http.post(url, this.params, options)
            : this.$http.get(url, options);
        request.then(function (documentData) {
            var reader = new FileReader();
            reader.readAsDataURL(documentData.data);
            reader.onloadend = function () {
                var base64String = reader.result;
                _this.printProvider.print(base64String.substring(base64String.indexOf(',') + 1), printSettings)
                    .then(function () {
                    _this.$modalInstance.close();
                }, function (error) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('printErrorMsg'), error);
                });
            };
        });
    };
    PrintModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    PrintModalCtrl.prototype.getPaperSizes = function (printerName) {
        var _this = this;
        this.printProvider.getPaperSizes(printerName)
            .then(function (paperSizes) {
            _this.paperSizes = paperSizes;
            _this.selectedPaperSize = _.first(_this.paperSizes);
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    PrintModalCtrl.$inject = [
        '$scope',
        '$http',
        '$modalInstance',
        'printProvider',
        'language',
        'notificationService',
        'clientSettings',
        'pdfFileUrl',
        'params'
    ];
    return PrintModalCtrl;
}());
angular.module('kamhpp').controller('printModalCtrl', PrintModalCtrl);
