app.directive('smsMatBalValue', function ($rootScope, $compile) {
    return {
        restrict: 'EA',
        priority: 1000,
        scope: {
            value: '@',
            roundedvalue: '@',
            ident: '@?',
            propident: '@?',
            haschanges: '@?',
            editable: '@?',
            hint: '@?',
            allowstrings: '@?',
        },
        link: function (scope, element, attrs) {
            var inputIndex = 1;
            scope.isEdited = scope.haschanges == 'true';
            scope.inputVisible = false;
            scope.onValueClick = function () {
                if (scope.editable != 'true')
                    return;
                $(scope.element[inputIndex]).attr('size', $(scope.element[inputIndex]).val().length);
                scope.inputVisible = true;
                if (_.isUndefined(scope.oldValue)) {
                    scope.oldValue = { value: scope.value, roundedvalue: scope.roundedvalue };
                }
                scope.lastValue = { value: scope.value, roundedvalue: scope.roundedvalue };
                if (scope.inputVisible) {
                    setTimeout(function () {
                        scope.element[inputIndex].focus();
                    }, 200);
                }
            };
            scope.lostFocus = function () {
                scope.inputVisible = false;
                var value = scope.value.replace(',', '.');
                if (value == scope.oldValue.value) {
                    scope.value = scope.oldValue.value;
                    return;
                }
                if (!$.isNumeric(value)) {
                    scope.value = scope.oldValue.value;
                    scope.roundedvalue = scope.oldValue.roundedvalue;
                    return;
                }
                scope.isEdited = true;
                var change = {
                    value: parseFloat(value),
                    oldvalue: parseFloat(scope.oldValue.value),
                    ident: scope.ident,
                    propIdent: scope.propident,
                };
                $rootScope.$broadcast('matBalValueEdited', change);
            };
            var cursorStyle = scope.isEdited ? 'cursor: pointer;' : 'cursor: default;';
            var template = "<div title='{{hint}}' class='matbalValue' edited='{{ isEdited }}' style='" +
                cursorStyle +
                "padding: 3px; display: inline;' ng-hide='inputVisible' ng-click='onValueClick()'>{{roundedvalue}}</div>" +
                "<input type='text' style='text-align: center;' ng-show='inputVisible' ng-blur='lostFocus()' ng-model='value' />";
            var t = angular.element($compile(template)(scope));
            scope.element = t;
            $(t[inputIndex]).bind('keydown keypress', function (event) {
                if (event.which === 13) {
                    scope.lostFocus();
                    scope.inputVisible = false;
                    scope.$apply();
                    event.preventDefault();
                }
                if (event.which === 27) {
                    scope.inputVisible = false;
                    scope.value = scope.lastValue.value;
                    scope.roundedvalue = scope.lastValue.roundedvalue;
                    scope.$apply();
                    event.preventDefault();
                }
            });
            element.replaceWith(t);
            var unregValueWatch = scope.$watch('value', function () {
                if (!scope.inputVisible) {
                    scope.isEdited = scope.haschanges == 'true';
                }
            });
            var unregistrationDestroyFunc = scope.$on('$destroy', function () {
                unregValueWatch();
                unregistrationDestroyFunc();
            });
        },
    };
});
