app.directive('smsContentEditableControl', [
    '$sce',
    function ($sce) {
        return {
            restrict: 'A',
            require: '?ngModel',
            link: function (scope, element, attrs, ngModel) {
                if (!ngModel) {
                    return;
                }
                ngModel.$render = function () {
                    element.html($sce.getTrustedHtml(ngModel.$viewValue || ''));
                };
                element.on('blur keyup change', function () {
                    scope.$evalAsync(setData);
                });
                var setData = function () {
                    var html = element.html();
                    if (!_.isUndefined(ngModel.$modelValue) && !_.isNaN(ngModel.$modelValue)) {
                        ngModel.$setViewValue(html);
                    }
                };
                setData();
            },
        };
    },
]);
