app.directive('smsCarousel', function () {
    return {
        restrict: 'E',
        scope: {
            tabs: '=',
            onSelected: '&?',
            value: '=',
            reset: '&?',
            addtabclick: '&?',
            deletetabclick: '&?',
            edittabclick: '&?'
        },
        template: '<div class="sms-carousel" style="position: relative;">' +
            '<div class="display: inline-block; position: absolute;">' +
            '<a class="pages-button sms-carousel-leftbutton">' +
            '<i class="fa fa-caret-left"> </i>' +
            '</a>' +
            '<a class="pages-button sms-carousel-rightbutton">' +
            '<i class="fa fa-caret-right" ></i>' +
            '</a>' +
            '<a ng-if="addtabclick" ng-click="addtabclick()" class="pages-button sms-carousel-leftbutton">' +
            '<i class="fa fa-plus"></i>' +
            '</a>' +
            '</div>' +
            '<div class="sms-carousel-items" style="margin-right: 38px;">' +
            '<ul class="sms-carousel-tabs nav nav-tabs" id="list">' +
            '<li class="pages-item nav-item"' +
            'ng-repeat="element in tabs track by $index"' +
            'ng-class="{\'active\': $index === value  }">' +
            '<div class="tab-btn-container">' +
            '<a ng-click="onSelected({index: $index})">{{ element.settings.name }} </a>' +
            '<a class="edit-crousel-tab-btn" ng-if="edittabclick"><i ng-click="edittabclick({index: $index})" class="fa fa-pencil"></i></a>' +
            '<a class="delete-crousel-tab-btn" ng-if="deletetabclick"><i ng-click="deletetabclick({index: $index})" class="fa fa-times"></i></a>' +
            '</div>' +
            '</li>' +
            '</ul>' +
            '</div>' +
            '</div>',
        link: function (scope, element, attrs) {
            var rightButtonIsDisabled = true;
            var leftButtonIsDisabled = true;
            var leftIndex = 0;
            var ulElementPositionValue = 0;
            var carouselItems = element.find('.sms-carousel-items');
            var ulElement = carouselItems.find('.sms-carousel-tabs');
            var leftButton = element.find('.sms-carousel-leftbutton');
            var rightButton = element.find('.sms-carousel-rightbutton');
            var setUlElementPosition = function (attributeValue) {
                ulElementPositionValue = attributeValue;
                ulElement.css('right', ulElementPositionValue);
            };
            var resetCarousel = function () {
                setUlElementPosition(0);
                leftIndex = 0;
            };
            var updateButtonAccessibility = function () {
                var items = ulElement.children();
                var parentWidth = carouselItems.outerWidth();
                var rightIndex = leftIndex;
                var itemsWidth = 0;
                while (items.length > rightIndex && itemsWidth < parentWidth) {
                    itemsWidth += items[rightIndex].offsetWidth;
                    rightIndex++;
                }
                rightButtonIsDisabled = itemsWidth <= parentWidth && items.length <= rightIndex;
                leftButtonIsDisabled = leftIndex === 0;
            };
            var pageNext = function () {
                updateButtonAccessibility();
                if (!rightButtonIsDisabled) {
                    var items = ulElement.children();
                    if (items.length - 1 > leftIndex) {
                        var newPosition = items[leftIndex].offsetWidth + ulElementPositionValue;
                        setUlElementPosition(newPosition);
                        leftIndex++;
                    }
                }
            };
            var pagePrev = function () {
                updateButtonAccessibility();
                if (!leftButtonIsDisabled) {
                    var items = ulElement.children();
                    if (leftIndex > 0) {
                        var newPosition = ulElementPositionValue - items[leftIndex - 1].offsetWidth;
                        setUlElementPosition(newPosition);
                        leftIndex--;
                    }
                }
            };
            if (_.isDefined(scope.reset)) {
                scope.reset({ resetFunction: resetCarousel });
            }
            leftButton.click(pagePrev);
            rightButton.click(pageNext);
        },
    };
});
