app.directive('hiddenPassword', function ($rootScope, $compile, language) {
    return {
        restrict: 'E',
        require: '^ngModel',
        scope: {
            placeholder: '@'
        },
        template: '<div class="input-group">' +
            '<input type="password" autocomplete="new-password" class="form-control" ng-model="password" ng-change="updateModel(password)" placeholder="{{ placeholder }}" required>' +
            '<span class="input-group-addon" ng-click="changeVisibility()" style="cursor: pointer; pointer-events: all;" ><i class="fa fa-eye"></i></span>' +
            '</div>',
        link: function (scope, element, attr, ngModelCtrl) {
            var _a;
            var isHidden = true;
            (_a = scope.placeholder) !== null && _a !== void 0 ? _a : (scope.placeholder = language.getElementValue('passwordPch'));
            scope.changeVisibility = function () {
                if (isHidden) {
                    element.find('i').removeClass('fa-eye');
                    element.find('i').addClass('fa-eye-slash');
                    element.find('input').prop('type', 'text');
                }
                else {
                    element.find('i').addClass('fa-eye');
                    element.find('i').removeClass('fa-eye-slash');
                    element.find('input').prop('type', 'password');
                }
                isHidden = !isHidden;
            };
            scope.updateModel = function (value) {
                ngModelCtrl.$setViewValue(value);
            };
            ngModelCtrl.$render = function () {
                scope.password = ngModelCtrl.$viewValue;
            };
        },
    };
});
