app.directive('colorPicker', [
    function () {
        return {
            restrict: 'E',
            require: 'ngModel',
            replace: true,
            scope: {
                showAlpha: '<?',
            },
            template: '<input type="text" />',
            link: function (scope, element, attrs, ngModel) {
                var spectrumId = 0;
                ngModel.$render = function () {
                    var _a;
                    element.spectrum({
                        color: ngModel.$viewValue,
                        preferredFormat: scope.showAlpha ? 'rgb' : 'hex',
                        showInput: true,
                        showAlpha: (_a = scope.showAlpha) !== null && _a !== void 0 ? _a : false,
                        move: function (color) {
                            ngModel.$setViewValue(scope.showAlpha ? color.toRgbString() : color.toHexString());
                        },
                    });
                    spectrumId = element.data('spectrum.id');
                };
                scope.$on('$destroy', function () {
                    element.data('spectrum.id', spectrumId);
                    element.spectrum('destroy');
                });
            },
        };
    },
]);
