app.directive('smsReportLog', function ($rootScope, reportSigningChecker, $modal, notificationService) {
    return {
        restrict: 'E',
        priority: 1000,
        replace: false,
        templateUrl: 'ng1/dist/src/_angular/_directives/_displayingReportElements/smsReportLog.html',
        scope: {
            data: '@?data',
            ts: '=?',
            ident: '=?',
            fields: '=?',
            dimension: '=?',
        },
        link: function (scope, element, attrs) {
            scope.rows = {
                current: JSON.parse(scope.data),
                beforeChange: JSON.parse(scope.data),
            };
            scope.tableWidth = 19;
            _.forEach(scope.fields, function (field) {
                scope.tableWidth += field.width;
            });
            scope.reportSigningChecker = reportSigningChecker;
            scope.addRow = function () {
                $rootScope.$broadcast('reportValueStartEdit');
                scope.showNewRowValuesDialog(scope.fields).then(function (row) {
                    scope.rows.current.push(row);
                    scope.updateData();
                });
            };
            scope.showNewRowValuesDialog = function (fields) {
                var modalInstance = $modal.open({
                    templateUrl: 'ng1/dist/src/_angular/_directives/_displayingReportElements/smsReportNewLogRowDialog.html',
                    controller: 'reportNewLogRowCtrl',
                    windowClass: 'app-modal-window newLogRowDialog',
                    backdrop: 'static',
                    resolve: {
                        fields: function () {
                            return fields;
                        },
                        ts: function () {
                            return scope.ts;
                        },
                        rows: function () {
                            return scope.rows.current;
                        },
                    },
                });
                return modalInstance.result;
            };
            scope.removeRow = function (idx) {
                $rootScope.$broadcast('reportValueStartEdit');
                var rows = _.filter(scope.rows.current, function (row) { return !row.isDeleted; });
                rows[idx].isDeleted = true;
                scope.updateData();
            };
            scope.updateData = function () {
                $rootScope.$broadcast('reportValueStartEdit');
                scope.data = JSON.stringify(DateExternalFormatParser.deepTransformDates(scope.rows.current));
                var change = {
                    newValue: scope.data,
                    oldValue: JSON.stringify(DateExternalFormatParser.deepTransformDates(scope.rows.beforeChange)),
                    timestamp: scope.ts,
                    ident: scope.ident,
                };
                $rootScope.$broadcast('reportValueEdited', change);
                scope.rows.beforeChange = _.deepclone(scope.rows.current);
            };
            scope.isStringField = function (field) {
                return field.type === 'string';
            };
            scope.isDoubleField = function (field) {
                return field.type === 'double';
            };
            scope.isTimeField = function (field) {
                return field.type === 'time';
            };
            scope.isDropdownField = function (field) {
                return field.type === 'dropdown';
            };
            scope.isDateTimeField = function (field) {
                return field.type === 'datetime';
            };
            var unregistrationDestroyFunc = scope.$on('$destroy', function () {
                unregistrationDestroyFunc();
            });
            if (_.isDefined(element[0].parentElement) && element[0].parentElement.tagName == 'P')
                element[0].parentElement.nextElementSibling.remove();
        },
    };
});
