var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var CreateReportTemplateModalCtrl = (function () {
    function CreateReportTemplateModalCtrl(scope, modalInstance, notificationService, reportTemplates, reportChapters, chapterName, name, language) {
        this.scope = scope;
        this.modalInstance = modalInstance;
        this.notificationService = notificationService;
        this.reportTemplates = reportTemplates;
        this.reportChapters = reportChapters;
        this.chapterName = chapterName;
        this.name = name;
        this.language = language;
        this.scope.ctrl = this;
        this.modalScope = {};
        this.modalScope.name = name;
        this.modalScope.chapter = chapterName;
        this.modalScope.reportType = 1;
        this.modalScope.hasStep = true;
        this.modalScope.step = '1h';
    }
    CreateReportTemplateModalCtrl.prototype.ok = function () {
        var _this = this;
        if (_.find(this.reportTemplates, function (template) {
            return template.Name == _this.modalScope.name;
        }) != undefined) {
            this.notificationService.warnMessage(this.language.getElementValue('reportNameMustBeUniqMsg'));
            return;
        }
        this.modalScope.reportTypesContainer.destroy();
        var _a = this.modalScope.reportType === 1
            ? this.getHtmlForPeriodicTemplate(this.modalScope.hasStep)
            : this.getHtmlForMomentTemplate(), html = _a.html, parameters = _a.parameters;
        this.modalInstance.close({
            name: this.modalScope.name,
            chapter: this.modalScope.chapter,
            reportType: parseInt(this.modalScope.reportType),
            hasStep: this.modalScope.hasStep,
            step: this.modalScope.step,
            parameters: parameters,
            htmlTemplate: html,
            reportStartDateOffset: '0d',
            reportDuration: '1d',
            reportStartDate: 2
        });
    };
    CreateReportTemplateModalCtrl.prototype.cancel = function () {
        this.modalScope.reportTypesContainer.destroy();
        this.modalInstance.dismiss();
    };
    CreateReportTemplateModalCtrl.prototype.init = function () {
        var _this = this;
        $('#newReportNameInput').focus();
        this.modalScope.reportTypesContainer = getVariantsContainer(this.scope, [
            new UiSelectItem(0, this.language.getElementValue('reportForTimeMomentSelectItem')),
            new UiSelectItem(1, this.language.getElementValue('reportPeriodicSelectItem')),
        ], function (t) {
            return t.ident === _this.modalScope.reportType;
        }, function (after, before) {
            if (after === before) {
                return;
            }
            _this.modalScope.reportType = after.ident;
            if (_this.modalScope.reportType === 0) {
                _this.modalScope.hasStep = false;
                _this.modalScope.step = '1h';
            }
        });
    };
    CreateReportTemplateModalCtrl.prototype.getTimestampFormat = function (step) {
        var stepDimension = step.slice(-1);
        switch (stepDimension) {
            case 's':
                return 'HH:mm:ss';
            case 'm':
            case 'h':
                return 'HH:mm';
            case 'd':
            case 'w':
                return 'yyyy.MM.dd-1d';
            case 'M':
                return 'yyyy.MM-1M';
            case 'y':
                return 'yyyy-1y';
        }
    };
    CreateReportTemplateModalCtrl.prototype.isValid = function () {
        return _.isEmpty(this.modalScope.chapter) || _.isEmpty(this.modalScope.name);
    };
    CreateReportTemplateModalCtrl.prototype.getHtmlForPeriodicTemplate = function (hasStep) {
        var reportStartParameter = {
            Ident: this.language.getElementValue('reportStartParameterNameHdr'),
            Timestamp: 0,
            Planned: true,
            Source: 'specificDate',
            ParameterType: 'DateTime',
            SpecificDate: {
                parameter: 'StartDate',
                format: 'dd.MM.yyyy HH:mm',
            },
            Formula: "StartDate",
        };
        var reportEndParameter = {
            Ident: this.language.getElementValue('reportEndParameterNameHdr'),
            Timestamp: 0,
            Planned: true,
            Source: 'specificDate',
            ParameterType: 'DateTime',
            SpecificDate: {
                parameter: 'EndDate',
                format: 'dd.MM.yyyy HH:mm',
            },
            Formula: "EndDate",
        };
        var reportStepParameter = {
            Ident: this.language.getElementValue('reportTimeHdr'),
            Timestamp: 3,
            Planned: true,
            Source: 'specificDate',
            ParameterType: 'DateTime',
            SpecificDate: {
                parameter: 'Timestamp',
                format: 'HH24:mm',
            },
            Formula: "Timestamp",
        };
        return {
            html: "<div data-report-page=\"".concat(this.language.getElementValue('reportNewPageHdr'), "\" class=\"report-page\"\n            style=\"padding:10mm 10mm 10mm 10mm;\">\n    <div class=\"report-row\">\n        <div class=\"report-column\" style=\"width:100%\">\n            <h2 style=\"text-align:center\">\n                ").concat(this.modalScope.name, "\n            </h2>\n        </div>\n    </div>\n    <div class=\"report-row\">\n        <div class=\"report-column\" style=\"width:100%\">\n            <h4 style=\"text-align:center\">\n                %").concat(reportStartParameter.Ident, "% - %").concat(reportEndParameter.Ident, "%\n            </h4>\n        </div>\n    </div>\n    <div class=\"report-row\">\n        <div class=\"report-column\" style=\"width:100%\">\n            <table align=\"center\" border=\"1\" cellpadding=\"2\" cellspacing=\"0\" class=\"report-table tablesorter\" style=\"border-color:#cccccc; width:600px\" sms-tablesorter=\"\">\n                <thead>\n                    <tr>\n                        ").concat(hasStep ? "<td style=\"background-color:rgb(238, 238, 238); text-align:center\">&nbsp;</td>" : '', "\n                        <td colspan=\"3\" style=\"background-color:rgb(238, 238, 238); text-align:center\">\n                            <strong>").concat(this.language.getElementValue('reportTitleHdr'), "</strong>\n                        </td>\n                    </tr>\n                    <tr>\n                        ").concat(hasStep
                ? "<th style=\"text-align: center; background-color: rgb(238, 238, 238);\">\n                            <strong>".concat(this.language.getElementValue('timeHdr'), "</strong>\n                        </th>")
                : '', "\n                        <th style=\"text-align: center; background-color: rgb(238, 238, 238);\">\n                            <strong>").concat(this.language.getElementValue('reportParameterHdr'), " 1</strong>\n                        </th>\n                        <th style=\"text-align: center; background-color: rgb(238, 238, 238);\">\n                            <strong>").concat(this.language.getElementValue('reportParameterHdr'), " 2</strong>\n                        </th>\n                        <th style=\"text-align: center; background-color: rgb(238, 238, 238);\">\n                            <strong>").concat(this.language.getElementValue('reportParameterHdr'), " 3</strong>\n                        </th>\n                    </tr>\n                </thead>\n                <tbody>\n                    <tr>\n                        ").concat(hasStep
                ? "<td style=\"text-align: center;\">%".concat(reportStepParameter.Ident, "%</td>")
                : '', "\n                        <td style=\"text-align: center;\"></td>\n                        <td style=\"text-align: center;\"></td>\n                        <td style=\"text-align: center;\"></td>\n                    </tr>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</div>"),
            parameters: __spreadArray([reportStartParameter, reportEndParameter], (hasStep ? [reportStepParameter] : []), true),
        };
    };
    CreateReportTemplateModalCtrl.prototype.getHtmlForMomentTemplate = function () {
        var reportStartParameter = {
            Ident: this.language.getElementValue('reportStartParameterNameHdr'),
            Timestamp: 0,
            Planned: true,
            Source: 'specificDate',
            ParameterType: 'DateTime',
            SpecificDate: {
                parameter: 'StartDate',
                format: 'dd.MM.yyyy HH:mm',
            },
            Formula: "StartDate",
        };
        return {
            html: "<div data-report-page=\"".concat(this.language.getElementValue('reportNewPageHdr'), "\" class=\"report-page\"\n            style=\"padding:10mm 10mm 10mm 10mm;\">\n    <div class=\"report-row\">\n        <div class=\"report-column\" style=\"width:100%\">\n            <h2 style=\"text-align:center\">\n                ").concat(this.modalScope.name, "\n            </h2>\n        </div>\n    </div>\n    <div class=\"report-row\">\n        <div class=\"report-column\" style=\"width:100%\">\n            <h4 style=\"text-align:center\">\n                %").concat(reportStartParameter.Ident, "%\n            </h4>\n        </div>\n    </div>\n    <div class=\"report-row\">\n        <div class=\"report-column\" style=\"width:100%\">\n            <table align=\"center\" border=\"1\" cellpadding=\"2\" cellspacing=\"0\" class=\"report-table tablesorter\" style=\"border-color:#cccccc; width:600px\" sms-tablesorter=\"\">\n                <thead>\n                    <tr>\n                        <td colspan=\"3\" style=\"background-color:rgb(238, 238, 238); text-align:center\">\n                            <strong>").concat(this.language.getElementValue('reportTitleHdr'), "</strong>\n                        </td>\n                    </tr>\n                    <tr>\n                        <th style=\"text-align: center; background-color: rgb(238, 238, 238);\">\n                            <strong>").concat(this.language.getElementValue('reportParameterHdr'), " 1</strong>\n                        </th>\n                        <th style=\"text-align: center; background-color: rgb(238, 238, 238);\">\n                            <strong>").concat(this.language.getElementValue('reportParameterHdr'), " 2</strong>\n                        </th>\n                        <th style=\"text-align: center; background-color: rgb(238, 238, 238);\">\n                            <strong>").concat(this.language.getElementValue('reportParameterHdr'), " 3</strong>\n                        </th>\n                    </tr>\n                </thead>\n                <tbody>\n                    <tr>\n                        <td style=\"text-align: center;\"></td>\n                        <td style=\"text-align: center;\"></td>\n                        <td style=\"text-align: center;\"></td>\n                    </tr>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</div>"),
            parameters: [reportStartParameter],
        };
    };
    CreateReportTemplateModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'notificationService',
        'reportTemplates',
        'reportChapters',
        'chapterName',
        'name',
        'language',
    ];
    return CreateReportTemplateModalCtrl;
}());
app.controller('createReportTemplateModalCtrl', CreateReportTemplateModalCtrl);
