var ReportTemplateMarkupCtrl = (function () {
    function ReportTemplateMarkupCtrl(language, $timeout, templateParameterService, configuration) {
        var _this = this;
        this.language = language;
        this.$timeout = $timeout;
        this.templateParameterService = templateParameterService;
        this.configuration = configuration;
        this.parameterFilter = '';
        this.reportTemplatePages = [];
        this.currentReportTemplatePageIndex = 0;
        this.sourceGroups = [
            this.language.getElementValue('groupDataSourcesHdr'),
            this.language.getElementValue('groupCalculatedParametersHdr'),
            this.language.getElementValue('groupComponentsHdr'),
        ];
        this.onEditorChange = function (editor) {
            _this.configuration.template.isChanged = true;
            _this.$timeout(function () {
                _this.html = editor.getData();
            });
        };
        this.filterParameters = function (parameter) {
            var _a;
            if ((_a = parameter.Ident) === null || _a === void 0 ? void 0 : _a.toLowerCase().includes(_this.parameterFilter.toLowerCase())) {
                return parameter;
            }
        };
    }
    ReportTemplateMarkupCtrl.prototype.setSelectedTemplate = function (template) {
        this.reportTemplatePages = this.getReportPages(template.HtmlTemplate);
        this.configuration.template = template;
        this.currentReportTemplatePageIndex = 0;
        this.html = this.reportTemplatePages[this.currentReportTemplatePageIndex].html;
        if (_.isDefined(this.editor)) {
            this.editor.undoManager.reset();
            this.openPage(this.editor, 0);
        }
    };
    ReportTemplateMarkupCtrl.prototype.getReportPages = function (html) {
        var reportTemplatePages = [];
        var parser = new DOMParser();
        var doc = parser.parseFromString(html, 'text/html');
        var reportPages = doc.querySelectorAll('div[data-report-page]');
        _.forEach(reportPages, function (page, index) {
            reportTemplatePages.push(new ReportPage(ReportPageSettings.createFrom(page), page.innerHTML, index));
        });
        if (_.isEmpty(reportTemplatePages)) {
            reportTemplatePages.push(new ReportPage(new ReportPageSettings(this.language.getElementValue('reportNewPageHdr')), html, 0));
        }
        return reportTemplatePages;
    };
    ReportTemplateMarkupCtrl.prototype.createParameter = function () {
        this.templateParameterService.createParameter(this.configuration.template).then(function () { }, function () { });
    };
    ReportTemplateMarkupCtrl.prototype.renameParameter = function (beforeParameterIdent, afterParameterIdent) {
        var _this = this;
        if (beforeParameterIdent === afterParameterIdent) {
            return;
        }
        var renameParameterOnPage = function (beforeParameterIdent, afterParameterIdent, pageHtml) {
            return pageHtml.replace(new RegExp('%' + beforeParameterIdent.escapeRegExp() + '%', 'g'), '%' + afterParameterIdent + '%');
        };
        _.forEach(this.reportTemplatePages, function (page) {
            if (page.index === _this.currentReportTemplatePageIndex) {
                _this.html = renameParameterOnPage(beforeParameterIdent, afterParameterIdent, _this.html);
                _this.configuration.setData(_this.editor, _this.html);
            }
            else {
                page.html = renameParameterOnPage(beforeParameterIdent, afterParameterIdent, page.html);
            }
        });
    };
    ReportTemplateMarkupCtrl.prototype.removeParameter = function (parameterIdent) {
        var _this = this;
        var removeParameterFromPage = function (parameterIdent, pageHtml) {
            return pageHtml.replace(new RegExp('%' + parameterIdent.escapeRegExp() + '%', 'g'), '');
        };
        _.forEach(this.reportTemplatePages, function (page) {
            if (page.index === _this.currentReportTemplatePageIndex) {
                _this.html = removeParameterFromPage(parameterIdent, _this.html);
                _this.configuration.setData(_this.editor, _this.html);
            }
            else {
                page.html = removeParameterFromPage(parameterIdent, page.html);
            }
        });
    };
    ReportTemplateMarkupCtrl.prototype.onEditorReady = function (editor) {
        var _this = this;
        this.editor = editor;
        this.configuration.onChange = this.onEditorChange;
        editor.on('dataReady', function (e) {
            if (e.editor.mode === '') {
                return;
            }
            if (e.editor.mode === "wysiwyg") {
                _this.updateCustomEditorPlugins(editor);
                _this.updateEditorPageStyle(editor);
            }
        });
        this.openPage(editor, 0);
        this.editor.window.$.addEventListener('click', function () {
            _this.onEditorSelectionChange(_this.editor);
        });
        this.sourceGroups = _.chain(TemplateParametersCtrl.parameterSourcesWithGroups)
            .map(function (item) { return item.group; })
            .filter(function (item, pos) {
            return (_(TemplateParametersCtrl.parameterSourcesWithGroups)
                .map(function (item) { return item.group; })
                .indexOf(item) == pos);
        })
            .value();
        CKEDITOR.document.getById('parametersSidebar').on('dragstart', function (event) {
            var eventData = event.data;
            window.CKEDITOR.plugins.clipboard.initDragDataTransfer(event);
            var dataTransfer = eventData.dataTransfer;
            var target = eventData.getTarget().$;
            var parameterIdent = target.parentElement.parentElement.querySelector('tr input.drag-info').dataset.parameterIdent;
            dataTransfer.$.setDragImage(target.parentElement.parentElement.querySelector('tr input.drag-info'), 0, 0);
            dataTransfer.setData('parameter', parameterIdent);
            dataTransfer.setData('text/html', parameterIdent);
        });
        this.configuration.onSelectionChange(editor);
        this.$timeout(function () { return _this.updateEditorPageStyle(_this.editor); });
    };
    ReportTemplateMarkupCtrl.prototype.onEditorSelectionChange = function (editor) {
        this.configuration.onSelectionChange(editor);
    };
    ;
    ReportTemplateMarkupCtrl.prototype.onKey = function (editor, event) {
        var shiftEnterKeyCode = 2228237;
        if ((event === null || event === void 0 ? void 0 : event.data).keyCode === shiftEnterKeyCode) {
            event.cancel();
            this.configuration.addRow(editor);
        }
        ;
        if (!this.configuration.isPreview(editor)) {
            this.onEditorChange(editor);
        }
    };
    ;
    ReportTemplateMarkupCtrl.prototype.onChangeMode = function (editor) {
        if (editor.mode === "wysiwyg") {
            this.updateCustomEditorPlugins(editor);
            this.updateEditorPageStyle(editor);
        }
        else {
            this.resetSourceTextAriaStyle();
        }
    };
    ;
    ReportTemplateMarkupCtrl.prototype.onPaste = function (event) {
        var eventData = event.data;
        var parameterIdent = eventData.dataTransfer.getData('parameter');
        var parameter = _.find(this.configuration.template.Parameters, function (p) { return p.Ident === parameterIdent; });
        if (_.isDefined(parameterIdent) && parameterIdent.length > 0) {
            eventData.dataValue = this.configuration.getReportParameterTag(parameter, this.configuration.isHighlightEnabled(this.editor));
        }
    };
    ;
    ReportTemplateMarkupCtrl.prototype.onEditorDoubleClick = function (editor) {
        var commands = _.filter(this.configuration.commands, function (command) { return command.name === 'parameterEdit' || command.name === 'timestampEdit'; });
        _.forEach(commands, function (command) { return command.execute(editor); });
    };
    ReportTemplateMarkupCtrl.prototype.onEditorContextMenuShow = function (editor) {
        this.configuration.selectedElement = editor.getSelection().getStartElement();
    };
    ReportTemplateMarkupCtrl.prototype.onEditorContextMenuHide = function () {
        var _this = this;
        this.$timeout(function () {
            _this.configuration.selectedElement = null;
        });
    };
    ReportTemplateMarkupCtrl.prototype.beforeCommandExec = function (editor, event) {
        this.configuration.beforeCommandExec(editor, event);
    };
    ReportTemplateMarkupCtrl.prototype.onDialogDefinition = function (editor, event) {
        var dialogName = event.data.name;
        var dialogDefinition = event.data.definition;
        if (dialogName === 'table') {
            var info = dialogDefinition.getContents('info');
            var advanced = dialogDefinition.getContents('advanced');
            info.get('selHeaders')['default'] = 'row';
            info.get('txtWidth')['default'] = '600px';
            info.get('txtCellPad')['default'] = '2';
            info.get('txtCellSpace')['default'] = '0';
            info.get('cmbAlign')['default'] = 'center';
            advanced.get('advCSSClasses')['default'] = 'report-table tablesorter';
            advanced.get('advStyles')['default'] = 'border-color:#cccccc; width:600px';
        }
        if (dialogName === 'table' || dialogName === 'tableProperties') {
            dialogDefinition.getContents('info').add({
                type: 'checkbox',
                id: 'sortable',
                default: true,
                label: this.language.getElementValue('sortHdr'),
                style: 'margin: 0',
                setup: function (selectedTable) {
                    this.setValue(selectedTable.hasAttribute('sms-tablesorter'));
                },
                commit: function (data, table) {
                    var dialog = this.getDialog();
                    if (this.getValue()) {
                        table.setAttribute('sms-tablesorter', '');
                        var cssClasses = dialog.getValueOf('advanced', 'advCSSClasses');
                        if (cssClasses.indexOf('tablesorter') === -1) {
                            dialog.setValueOf('advanced', 'advCSSClasses', cssClasses + ' tablesorter');
                        }
                    }
                    else {
                        table.removeAttribute('sms-tablesorter');
                        dialog.setValueOf('advanced', 'advCSSClasses', dialog.getValueOf('advanced', 'advCSSClasses').replace('tablesorter', ''));
                    }
                },
            });
            dialogDefinition.getContents('info').add({
                type: 'checkbox',
                id: 'selectableRows',
                default: false,
                label: this.language.getElementValue('selectableRowsHdr'),
                style: 'margin: 0',
                setup: function (selectedTable) {
                    this.setValue(selectedTable.hasAttribute('sms-selectable-rows'));
                },
                commit: function (data, table) {
                    if (this.getValue()) {
                        table.setAttribute('sms-selectable-rows', '');
                    }
                    else {
                        table.removeAttribute('sms-selectable-rows');
                    }
                }
            });
            dialogDefinition.getContents('info').add({
                type: 'checkbox',
                id: 'stickyTableHeaders',
                default: false,
                label: this.language.getElementValue('stickyTableHeadersHdr'),
                style: 'margin: 0',
                setup: function (selectedTable) {
                    this.setValue(selectedTable.hasAttribute('sticky-table-headers'));
                },
                onChange: function () {
                    var dialog = this.getDialog();
                    var widthField = dialog.getContentElement('advanced', 'containerWidth');
                    var heightField = dialog.getContentElement('advanced', 'containerHeight');
                    if (this.getValue()) {
                        widthField.getElement().show();
                        heightField.getElement().show();
                    }
                    else {
                        widthField.getElement().hide();
                        heightField.getElement().hide();
                    }
                },
                commit: function (data, table) {
                    if (this.getValue()) {
                        table.setAttribute('sticky-table-headers', '');
                    }
                    else {
                        table.removeAttribute('sticky-table-headers');
                    }
                }
            });
            dialogDefinition.getContents('advanced').add({
                type: 'hbox',
                widths: ['50%', '50%'],
                children: [
                    {
                        type: 'text',
                        id: 'containerWidth',
                        default: '100%',
                        label: this.language.getElementValue('stickyTableContainerWidthHdr'),
                        style: 'width: 100%',
                        setup: function (selectedTable) {
                            this.setValue(selectedTable.getAttribute('container-width') || '100%');
                        },
                        commit: function (data, table) {
                            if (_.isDefined(table.getAttribute('sticky-table-headers'))) {
                                table.setAttribute('container-width', this.getValue());
                            }
                        }
                    },
                    {
                        type: 'text',
                        id: 'containerHeight',
                        default: '500px',
                        label: this.language.getElementValue('stickyTableContainerHeightHdr'),
                        style: 'width: 100%',
                        setup: function (selectedTable) {
                            this.setValue(selectedTable.getAttribute('container-height'));
                        },
                        commit: function (data, table) {
                            if (_.isDefined(table.getAttribute('sticky-table-headers'))) {
                                table.setAttribute('container-height', this.getValue() || '500px');
                            }
                        }
                    }
                ]
            });
        }
    };
    ReportTemplateMarkupCtrl.prototype.openPage = function (editor, index) {
        var _this = this;
        this.reportTemplatePages[this.currentReportTemplatePageIndex].html = _.isDefined(this.html)
            ? (this.configuration.isPreview(this.editor) ? this.configuration.htmlBeforePreviewOpened : this.html)
            : this.reportTemplatePages[this.currentReportTemplatePageIndex].html;
        this.currentReportTemplatePageIndex = index;
        var html = this.configuration.unwrapParameters(this.reportTemplatePages[index].html);
        this.html = this.configuration.wrapParameters(html);
        if (this.configuration.isPreview(editor)) {
            this.configuration.htmlBeforePreviewOpened = this.html;
            this.configuration.getPreview(this.configuration.template, this.html).then(function (previewHtml) {
                _this.configuration.setData(editor, previewHtml, { ignoreChanges: true, resetUndoManager: true });
            });
        }
        else {
            this.configuration.setData(editor, this.html, { ignoreChanges: true, resetUndoManager: true });
        }
        this.currentReportTemplatePageIndex = index;
        if (editor.mode === "wysiwyg" && _.isDefined(this.reportTemplatePages[this.currentReportTemplatePageIndex].settings.size)) {
            this.updateEditorPageStyle(editor);
        }
        if (editor.mode === "source") {
            this.resetSourceTextAriaStyle();
        }
    };
    ReportTemplateMarkupCtrl.prototype.updateEditorPageStyle = function (editor) {
        var _a, _b, _c, _d;
        var ckEditorBodyElement = editor === null || editor === void 0 ? void 0 : editor.editable();
        if (_.isUndefined(ckEditorBodyElement)) {
            return;
        }
        ckEditorBodyElement.addClass('report-page');
        var pageSettings = this.reportTemplatePages[this.currentReportTemplatePageIndex].settings;
        if (editor.mode === "wysiwyg"
            && _.isDefined(pageSettings)
            && (_.isDefined((_a = pageSettings === null || pageSettings === void 0 ? void 0 : pageSettings.size) === null || _a === void 0 ? void 0 : _a.width) || _.isDefined((_b = pageSettings === null || pageSettings === void 0 ? void 0 : pageSettings.size) === null || _b === void 0 ? void 0 : _b.height))
            && (!_.isNaN((_c = pageSettings === null || pageSettings === void 0 ? void 0 : pageSettings.size) === null || _c === void 0 ? void 0 : _c.width) || !_.isNaN((_d = pageSettings === null || pageSettings === void 0 ? void 0 : pageSettings.size) === null || _d === void 0 ? void 0 : _d.height))) {
            ckEditorBodyElement.setStyles({
                "background": "#ffffff",
                'margin': '30px auto',
                'width': "".concat(pageSettings.size.width, "mm"),
                'height': "".concat(pageSettings.size.height, "mm"),
                'padding': "".concat(pageSettings.paddings.toCssString()),
                'border': '1px #D3D3D3 solid',
                'border-radius': '5px',
                'box-shadow': '0 0 5px rgba(0, 0, 0, 0.1)',
                'box-sizing': 'border-box'
            });
            ckEditorBodyElement.getParent().setStyles({
                'background': '#eeeeee',
            });
        }
        else {
            this.resetEditorPageStyle();
        }
    };
    ReportTemplateMarkupCtrl.prototype.updateCustomEditorPlugins = function (editor) {
        this.configuration.updateHighlightMode(editor);
        this.configuration.updateShowStructureMode(editor);
        this.configuration.updateStructuralBlocksJsBehavior(editor);
    };
    ReportTemplateMarkupCtrl.prototype.resetEditorPageStyle = function () {
        if (_.isDefined(this.editor) && this.editor.mode === 'wysiwyg') {
            var ckEditorBodyElement = this.editor.editable();
            ckEditorBodyElement === null || ckEditorBodyElement === void 0 ? void 0 : ckEditorBodyElement.removeStyle("background");
            ckEditorBodyElement === null || ckEditorBodyElement === void 0 ? void 0 : ckEditorBodyElement.removeStyle("margin");
            ckEditorBodyElement === null || ckEditorBodyElement === void 0 ? void 0 : ckEditorBodyElement.removeStyle("width");
            ckEditorBodyElement === null || ckEditorBodyElement === void 0 ? void 0 : ckEditorBodyElement.removeStyle("height");
            ckEditorBodyElement === null || ckEditorBodyElement === void 0 ? void 0 : ckEditorBodyElement.removeStyle("padding");
            var htmlContainer = ckEditorBodyElement === null || ckEditorBodyElement === void 0 ? void 0 : ckEditorBodyElement.getParent();
            htmlContainer === null || htmlContainer === void 0 ? void 0 : htmlContainer.removeStyle("margin");
            htmlContainer === null || htmlContainer === void 0 ? void 0 : htmlContainer.removeStyle("padding");
            htmlContainer === null || htmlContainer === void 0 ? void 0 : htmlContainer.removeStyle("width");
            htmlContainer === null || htmlContainer === void 0 ? void 0 : htmlContainer.removeStyle("display");
            htmlContainer === null || htmlContainer === void 0 ? void 0 : htmlContainer.removeStyle("background");
            htmlContainer === null || htmlContainer === void 0 ? void 0 : htmlContainer.removeStyle("border");
            htmlContainer === null || htmlContainer === void 0 ? void 0 : htmlContainer.removeStyle("box-shadow");
        }
    };
    ReportTemplateMarkupCtrl.prototype.resetSourceTextAriaStyle = function () {
        var textAria = this.editor.editable();
        textAria === null || textAria === void 0 ? void 0 : textAria.setStyle("width", "100%");
        textAria === null || textAria === void 0 ? void 0 : textAria.setStyle("height", "100%");
        textAria === null || textAria === void 0 ? void 0 : textAria.removeStyle("padding");
        textAria === null || textAria === void 0 ? void 0 : textAria.removeStyle("margin");
    };
    ReportTemplateMarkupCtrl.prototype.applyMarkupChanges = function () {
        this.reportTemplatePages[this.currentReportTemplatePageIndex].html = _.isDefined(this.html)
            ? (this.configuration.isPreview(this.editor) ? this.configuration.htmlBeforePreviewOpened : this.html)
            : this.reportTemplatePages[this.currentReportTemplatePageIndex].html;
    };
    ReportTemplateMarkupCtrl.prototype.addPage = function () {
        var _this = this;
        this.configuration.getPageModalInstance().result
            .then(function (result) {
            var _a;
            var html = "<div class=\"report-row\">\n                                    <div class=\"report-column\" style=\"width:100%\">\n                                        <p>".concat(result.name, "</p>\n                                    </div>\n                                </div>");
            _this.reportTemplatePages.push(new ReportPage(new ReportPageSettings(result.name, result.size, result.paddings), html, ((_a = _.max(_this.reportTemplatePages, function (p) { return p.index; })) === null || _a === void 0 ? void 0 : _a.index) + 1 || 0));
            _this.configuration.template.isChanged = true;
            _this.openPage(_this.editor, _this.reportTemplatePages.length - 1);
        }, function () { });
    };
    ReportTemplateMarkupCtrl.prototype.editPage = function (index) {
        var _this = this;
        this.configuration.getPageModalInstance(this.reportTemplatePages[index].settings).result
            .then(function (result) {
            _this.reportTemplatePages[index] = new ReportPage(new ReportPageSettings(result.name, result.size, result.paddings), _this.currentReportTemplatePageIndex === index ? _this.html : _this.reportTemplatePages[index].html, _this.reportTemplatePages[index].index);
            _this.configuration.template.isChanged = true;
            if (_this.currentReportTemplatePageIndex === index) {
                _this.updateEditorPageStyle(_this.editor);
            }
        }, function () { });
    };
    ReportTemplateMarkupCtrl.prototype.deletePage = function (index) {
        if (this.reportTemplatePages.length == 1) {
            return;
        }
        this.reportTemplatePages.splice(index, 1);
        this.configuration.template.isChanged = true;
        if (this.currentReportTemplatePageIndex > index) {
            this.currentReportTemplatePageIndex -= 1;
        }
        if (this.currentReportTemplatePageIndex !== index) {
            return;
        }
        if (this.reportTemplatePages.length !== 0) {
            this.html = undefined;
            if (index === 0) {
                this.currentReportTemplatePageIndex = 0;
                this.openPage(this.editor, this.currentReportTemplatePageIndex);
            }
            else {
                this.currentReportTemplatePageIndex = index - 1;
                this.openPage(this.editor, this.currentReportTemplatePageIndex);
            }
        }
    };
    ReportTemplateMarkupCtrl.prototype.moveLeftPage = function (index) {
        if (index <= 0) {
            return;
        }
        var page = this.reportTemplatePages[index];
        this.reportTemplatePages[index] = this.reportTemplatePages[index - 1];
        this.reportTemplatePages[index - 1] = page;
        if (index === this.currentReportTemplatePageIndex) {
            this.currentReportTemplatePageIndex--;
        }
        else if (index - 1 === this.currentReportTemplatePageIndex) {
            this.currentReportTemplatePageIndex++;
        }
        this.configuration.template.isChanged = true;
    };
    ReportTemplateMarkupCtrl.prototype.moveRightPage = function (index) {
        if (index >= this.reportTemplatePages.length - 1) {
            return;
        }
        var page = this.reportTemplatePages[index];
        this.reportTemplatePages[index] = this.reportTemplatePages[index + 1];
        this.reportTemplatePages[index + 1] = page;
        if (index === this.currentReportTemplatePageIndex) {
            this.currentReportTemplatePageIndex++;
        }
        else if (index + 1 === this.currentReportTemplatePageIndex) {
            this.currentReportTemplatePageIndex--;
        }
        this.configuration.template.isChanged = true;
    };
    ReportTemplateMarkupCtrl.prototype.getHtml = function () {
        this.reportTemplatePages[this.currentReportTemplatePageIndex].html = _.isDefined(this.html)
            ? (this.configuration.isPreview(this.editor) ? this.configuration.htmlBeforePreviewOpened : this.html)
            : this.reportTemplatePages[this.currentReportTemplatePageIndex].html;
        if (this.reportTemplatePages.length) {
            return this.configuration.unwrapParameters(_.reduce(this.reportTemplatePages, function (result, page) {
                var div = $('<div>').html(page.html);
                div.addClass('report-page');
                div.attr(ReportPageSettings.pageAttribute, page.settings.name);
                div.css(ReportPageSettings.width, "".concat(page.settings.size.width, "mm"));
                div.css(ReportPageSettings.heght, "".concat(page.settings.size.height, "mm"));
                div.css(ReportPageSettings.paddingTop, "".concat(page.settings.paddings.top, "mm"));
                div.css(ReportPageSettings.paddingRight, "".concat(page.settings.paddings.right, "mm"));
                div.css(ReportPageSettings.paddingBottom, "".concat(page.settings.paddings.bottom, "mm"));
                div.css(ReportPageSettings.paddingLeft, "".concat(page.settings.paddings.left, "mm"));
                return result + div[0].outerHTML;
            }, ''));
        }
    };
    return ReportTemplateMarkupCtrl;
}());
