var ParameterBacklightSettingCtrl = (function () {
    function ParameterBacklightSettingCtrl(parentScope, language) {
        var _this = this;
        this.parentScope = parentScope;
        this.language = language;
        this.parentScope.param.Backlight = _.map(this.parentScope.param.Backlight, function (item) {
            return new ReportParameterBacklightExt(_this.parentScope, item, _this.language);
        });
    }
    ParameterBacklightSettingCtrl.prototype.insert = function () {
        this.parentScope.param.Backlight.push(new ReportParameterBacklightExt(this.parentScope, new ReportParameterBacklight(), this.language));
    };
    ParameterBacklightSettingCtrl.prototype.remove = function (index) {
        this.parentScope.param.Backlight.splice(index, 1);
    };
    ParameterBacklightSettingCtrl.prototype.moveUp = function (index) {
        var newIndex = index - 1;
        var movedElement = this.parentScope.param.Backlight.splice(index, 1)[0];
        this.parentScope.param.Backlight.splice(newIndex, 0, movedElement);
    };
    ParameterBacklightSettingCtrl.prototype.moveDown = function (index) {
        var newIndex = index + 1;
        var movedElement = this.parentScope.param.Backlight.splice(index, 1)[0];
        this.parentScope.param.Backlight.splice(newIndex, 0, movedElement);
    };
    ParameterBacklightSettingCtrl.prototype.openAllItems = function () {
        _.forEach(this.parentScope.param.Backlight, function (backlight) {
            backlight.isOpen = true;
        });
    };
    ParameterBacklightSettingCtrl.prototype.destroy = function () {
        _.forEach(this.parentScope.param.Backlight, function (item) {
            item.destroy();
        });
        this.parentScope = undefined;
    };
    return ParameterBacklightSettingCtrl;
}());
