var WinccOaSettings = (function () {
    function WinccOaSettings(templateHasStep) {
        this.func = 'dpGet';
        this.startTimestamp = templateHasStep
            ? 'StepStart'
            : 'StartDate';
        this.endTimestamp = templateHasStep
            ? 'StepEnd'
            : 'EndDate';
        this.requestDPValuesSettings = new WinccOaDpRequestSettings();
        this.queryAlarmsSettings = null;
        this.querySettings = null;
        this.connectionGuid = '';
    }
    WinccOaSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new WinccOaSettings();
        clone.connectionGuid = obj.connectionGuid;
        clone.func = obj.func;
        clone.startTimestamp = obj.startTimestamp;
        clone.endTimestamp = obj.endTimestamp;
        clone.querySettings = WinccOaQuerySettings.clone(obj.querySettings);
        clone.queryAlarmsSettings = WinccoaQueryAlarmsSettings.clone(obj.queryAlarmsSettings);
        clone.requestDPValuesSettings = WinccOaDpRequestSettings.clone(obj.requestDPValuesSettings);
        clone.catalogMessageSettings = WinccOaCatalogMessageSettings.clone(obj.catalogMessageSettings);
        return clone;
    };
    WinccOaSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        if (obj.connectionGuid !== other.connectionGuid
            || obj.startTimestamp !== other.startTimestamp
            || obj.endTimestamp !== other.endTimestamp
            || obj.func !== other.func) {
            return false;
        }
        return (WinccOaQuerySettings.isEqual(obj.querySettings, other.querySettings)
            && WinccoaQueryAlarmsSettings.isEqual(obj.queryAlarmsSettings, other.queryAlarmsSettings)
            && WinccOaDpRequestSettings.isEqual(obj.requestDPValuesSettings, other.requestDPValuesSettings)
            && WinccOaCatalogMessageSettings.isEqual(obj.catalogMessageSettings, other.catalogMessageSettings));
    };
    WinccOaSettings.prototype.canEdited = function () {
        return (this.func !== 'dpAlarmsOnPeriod'
            && this.func !== 'queryAsHtmlTable'
            && this.func !== 'queryEventsAsHtmlTable'
            && this.func !== 'dpBitNumber');
    };
    WinccOaSettings.prototype.canPlanned = function () {
        return true;
    };
    WinccOaSettings.prototype.canBacklight = function () {
        return !_.contains(['queryAsHtmlTable', 'dpAlarmsOnPeriod', 'dpGetOnPeriod', 'queryEventsAsHtmlTable'], this.func);
    };
    WinccOaSettings.prototype.canPredefined = function () {
        return false;
    };
    return WinccOaSettings;
}());
