var WinccOaInfluxSettingsCtrl = (function () {
    function WinccOaInfluxSettingsCtrl(parentScope, language) {
        this.parentScope = parentScope;
        this.language = language;
        this.functions = [];
        this.connectionTypes = [10];
        this.watchFunctions = [];
    }
    WinccOaInfluxSettingsCtrl.prototype.init = function () {
        var self = this;
        this.functions = getVariantsContainer(this.parentScope, [
            new WccoaFuncUiSelectItem('dpGet', this.language.getElementValue('winccValueParameterTimeStampHdr'), false, 'WinccOaValue', 'WinccOaInfluxGet'),
            new WccoaFuncUiSelectItem('dpGetOnPeriod', this.language.getElementValue('winccGetOnPeriodHdr'), true, 'WinccOaValue[]', 'WinccOaInfluxGetPeriod'),
        ], function (t) {
            return t.ident === self.parentScope.param.WinccOaInflux.func;
        }, function (after, before) {
            if (_.isUndefined(after) || after === before) {
                return;
            }
            self.parentScope.param.WinccOaInflux.func = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
            if (!self.canEdited()) {
                self.parentScope.param.Editable = false;
            }
        });
        this.startPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.parentScope.param.WinccOaInflux.startTimestamp;
        }, function (after, before) {
            if (after === before || _.isUndefined(after)) {
                return;
            }
            self.parentScope.param.WinccOaInflux.startTimestamp = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.parentScope.settingsCtrl.sourceCtrl.getFormula());
        });
        this.endPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.parentScope.param.WinccOaInflux.endTimestamp;
        }, function (after, before) {
            if (after === before || _.isUndefined(after)) {
                return;
            }
            self.parentScope.param.WinccOaInflux.endTimestamp = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.parentScope.settingsCtrl.sourceCtrl.getFormula());
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.WinccOaInflux;
        }, function (before, after) {
            if (_.isUndefined(self.parentScope.param.WinccOaInflux)
                || _.isNull(self.parentScope.param.WinccOaInflux)
                || _.isUndefined(after)) {
                return;
            }
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    WinccOaInfluxSettingsCtrl.prototype.isPeriodic = function () {
        return this.functions.selected && this.functions.selected.isPeriodic;
    };
    WinccOaInfluxSettingsCtrl.prototype.destroy = function () {
        this.functions.destroy();
        this.startPeriods.destroy();
        this.endPeriods.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    WinccOaInfluxSettingsCtrl.prototype.getFormula = function () {
        if (!this.functions.selected) {
            return '';
        }
        var params = '"'
            + this.parentScope.param.WinccOaInflux.connectionGuid
            + '", '
            + '"'
            + this.parentScope.param.WinccOaInflux.dataPointAddress
            + '", '
            + ''
            + this.parentScope.param.WinccOaInflux.startTimestamp
            + (this.functions.selected.isPeriodic
                ? ', ' + this.parentScope.param.WinccOaInflux.endTimestamp
                : '');
        switch (this.functions.selected.ident) {
            case 'dpGet':
                return "return ".concat(this.functions.selected.alias, "(").concat(params, ");");
            case 'dpGetOnPeriod':
                return "return ".concat(this.functions.selected.alias, "(").concat(params, ");");
        }
        return '';
    };
    WinccOaInfluxSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    WinccOaInfluxSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.WinccOaInflux.canEdited();
    };
    WinccOaInfluxSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.WinccOaInflux.canPlanned();
    };
    WinccOaInfluxSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.WinccOaInflux.canBacklight();
    };
    WinccOaInfluxSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.WinccOaInflux.canPredefined();
    };
    return WinccOaInfluxSettingsCtrl;
}());
