var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var OperationTimeDiagramSettingsCtrl = (function () {
    function OperationTimeDiagramSettingsCtrl(parentScope, operationTimeParameterProvider, language, notificationService) {
        this.parentScope = parentScope;
        this.operationTimeParameterProvider = operationTimeParameterProvider;
        this.language = language;
        this.notificationService = notificationService;
    }
    OperationTimeDiagramSettingsCtrl.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var self, operationTimeParameters, error_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        self = this;
                        this.setting = this.parentScope.param.OperationTimeDiagram;
                        operationTimeParameters = null;
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4, this.operationTimeParameterProvider.getAllShortInfo()];
                    case 2:
                        operationTimeParameters = _a.sent();
                        return [3, 4];
                    case 3:
                        error_1 = _a.sent();
                        this.notificationService.errorMessage(this.language.getElementValue('failedLoadDataServerMsg'), error_1);
                        return [3, 4];
                    case 4:
                        this.parameters = getVariantsContainer(self.parentScope, _.map(operationTimeParameters, function (parameter) {
                            return new UiSelectOperationTimeParameter(parameter);
                        }), function (t) {
                            return t.ident === self.setting.parameterName;
                        }, function (after, before) {
                            if (after === before || after === undefined)
                                return;
                            self.setting.parameterName = after.ident;
                            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
                        });
                        this.startDates = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
                            return self.setting.startDate;
                        }, function (after, before) {
                            if (after === before || after === undefined)
                                return;
                            self.setting.startDate = after.ident;
                            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
                        });
                        if (_.isUndefined(this.setting.startDate)) {
                            this.startDates.selected = this.parentScope.settingsCtrl.getStartTimestamp();
                            self.setting.startDate = this.startDates.selected.ident;
                        }
                        this.endDates = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
                            return self.setting.endDate;
                        }, function (after, before) {
                            if (after === before || after === undefined)
                                return;
                            self.setting.endDate = after.ident;
                            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
                        });
                        if (_.isUndefined(this.setting.endDate)) {
                            this.endDates.selected = this.parentScope.settingsCtrl.getEndTimestamp();
                            self.setting.endDate = this.endDates.selected.ident;
                        }
                        this.legendPositions = getVariantsContainer(this.parentScope, [
                            new UiSelectItem(0, self.language.getElementValue('reportChartLegendPositionNoneHdr')),
                            new UiSelectItem(1, self.language.getElementValue('reportChartLegendPositionBottomHdr')),
                            new UiSelectItem(2, self.language.getElementValue('reportChartLegendPositionTopHdr')),
                        ], function (t) {
                            return t.ident === self.setting.legendPosition;
                        }, function (after, before) {
                            if (after === before || after === undefined)
                                return;
                            self.setting.legendPosition = after.ident;
                        });
                        this.parentScope.settingsCtrl.formulaCtrl.setResultType('OperationTimeParameterLog');
                        if (!this.canEdited()) {
                            this.parentScope.param.Editable = false;
                        }
                        return [2];
                }
            });
        });
    };
    OperationTimeDiagramSettingsCtrl.prototype.destroy = function () {
        this.startDates.destroy();
        this.endDates.destroy();
        this.parameters.destroy();
    };
    OperationTimeDiagramSettingsCtrl.prototype.getFormula = function () {
        return String.Format('return OperationTimeGetLogForPeriod("{0}", {1}, {2});', this.setting.parameterName, this.setting.startDate, this.setting.endDate);
    };
    OperationTimeDiagramSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        if (_.isUndefined(this.parameters) || this.parameters == null || !this.parameters.selected) {
            return true;
        }
        return false;
    };
    OperationTimeDiagramSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.OperationTimeDiagram.canEdited();
    };
    OperationTimeDiagramSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.OperationTimeDiagram.canPlanned();
    };
    OperationTimeDiagramSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.OperationTimeDiagram.canBacklight();
    };
    OperationTimeDiagramSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.OperationTimeDiagram.canPredefined();
    };
    return OperationTimeDiagramSettingsCtrl;
}());
