var OleDbSettings = (function () {
    function OleDbSettings() {
        this.func = 'table';
        this.includeHeader = true;
        this.sql = '';
    }
    OleDbSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.connectionGuid === other.connectionGuid &&
            obj.func === other.func &&
            obj.sql === other.sql &&
            obj.includeHeader === other.includeHeader);
    };
    OleDbSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new OleDbSettings();
        clone.connectionGuid = obj.connectionGuid;
        clone.func = obj.func;
        clone.sql = obj.sql;
        clone.includeHeader = obj.includeHeader;
        return clone;
    };
    OleDbSettings.prototype.canEdited = function () {
        return this.func === 'cellString' || this.func === 'cellDouble';
    };
    OleDbSettings.prototype.canPlanned = function () {
        return true;
    };
    OleDbSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'doubleArray', 'stringOneDimArray'], this.func);
    };
    OleDbSettings.prototype.canPredefined = function () {
        return false;
    };
    return OleDbSettings;
}());
