var OdbcSettings = (function () {
    function OdbcSettings() {
        this.func = 'table';
        this.includeHeader = true;
        this.sql = '';
    }
    OdbcSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.connectionGuid === other.connectionGuid &&
            obj.func === other.func &&
            obj.includeHeader === other.includeHeader &&
            obj.sql === other.sql);
    };
    OdbcSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new OdbcSettings();
        clone.connectionGuid = obj.connectionGuid;
        clone.func = obj.func;
        clone.includeHeader = obj.includeHeader;
        clone.sql = obj.sql;
        return clone;
    };
    OdbcSettings.prototype.canEdited = function () {
        return false;
    };
    OdbcSettings.prototype.canPlanned = function () {
        return true;
    };
    OdbcSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'doubleArray', 'stringOneDimArray', 'objectArray'], this.func);
    };
    OdbcSettings.prototype.canPredefined = function () {
        return false;
    };
    return OdbcSettings;
}());
