var ChartFormulaFactory = (function () {
    function ChartFormulaFactory(language) {
        this.language = language;
        this.reportChartValueName = 'ReportChartValue';
        this.lineDashStyles = [
            { dashStyle: 0, js: 'dash' },
            { dashStyle: 1, js: 'dashDot' },
            { dashStyle: 2, js: 'longDashDotDot' },
            { dashStyle: 3, js: 'dot' },
            { dashStyle: 4, js: 'solid' }
        ];
    }
    ChartFormulaFactory.prototype.getFormula = function (parameter, templateParameters) {
        var _a;
        var chart = parameter.Chart;
        var xAxisParameter = _.find(templateParameters, function (parameter) { var _a; return parameter.Ident === ((_a = chart.AxisX.custom) === null || _a === void 0 ? void 0 : _a.parameterIdent); });
        var title = (_a = chart.Title) === null || _a === void 0 ? void 0 : _a.replaceAllPolyfill('"', '""');
        return "".concat(this.isPieChart(chart) ? '' : this.getCategories(chart.AxisX), "return new ").concat(this.reportChartValueName, "()\n{\n    Value = @$\"{{\n        chart: {{\n            width: ").concat(chart.Size.width === 0 ? null : chart.Size.width, ",\n            height: ").concat(chart.Size.height === 0 ? null : chart.Size.height, ",\n            type: '").concat(this.getChartType(chart), "',\n            zoomType: 'xy'\n        }},\n\n        series: [ \n            ").concat(this.getSeries(chart, templateParameters), "\n        ],\n\n        ").concat(this.getLegend(chart)).concat(this.getAxisX(chart, xAxisParameter)).concat(this.getYAxis(chart), "\n        plotOptions: {{\n            series: {{\n                turboThreshold: 0,\n                animation: null,").concat(chart.Type === 2
            ? "\n                stacking: 'normal',"
            : '', "\n            }},\n            ").concat(this.isPieChart(chart) ? "pie: {{\n                allowPointSelect: true,\n                showInLegend: ".concat(chart.LegendPosition !== 0, "\n            }}") : '', " \n        }},\n\n        title: {{\n            text: ").concat((title === null || title === void 0 ? void 0 : title.length) > 0 ? "'".concat(title, "'") : null, ",\n        }},\n\n        tooltip: {{\n            headerFormat: '{{point.x:%d.%m.%Y %H:%M:%S}}<br>',\n        }},\n\n        credits: {{\n            enabled: false\n        }}\n    }}\", \n    Width = (int)").concat(chart.Size.width, ", \n    Height = (int)").concat(chart.Size.height, "\n};");
    };
    ChartFormulaFactory.prototype.getSeries = function (chart, templateParameters) {
        var _this = this;
        var _a;
        if (this.isPieChart(chart)) {
            return "{{\n                name: '".concat((_a = chart.Title) !== null && _a !== void 0 ? _a : '', "',\n                data: [ ").concat(_.map(chart.Series, function (series) {
                return "\n                    {{\n                        name: '".concat(series.parameterIdent, "',\n                        color: '").concat(series.color, "',\n                        y: {((%").concat(series.parameterIdent, "% as object) is IReportParameterValueForCalculator ? ((IReportParameterValueForCalculator)(%").concat(series.parameterIdent, "% as object)).Value : Convert.ToDouble(%").concat(series.parameterIdent, "%)).ToString(\"0.00\", CultureInfo.InvariantCulture)},\n                        ").concat(_.isDefined(series.callout)
                    ? "dataLabels: {{\n                            enabled: true,\n                            useHtml: true,\n                            color: '".concat(series.callout.color, "',\n                            style: {{\n                                fontSize: '").concat(series.callout.fontSize, "px'\n                            }},\n                            crop: false,\n                            allowOverlap: true,\n                        }}")
                    : "dataLabels: {{\n                            enabled: false,\n                        }}", "\n                    }}");
            }), "\n                ],\n            }}");
        }
        var xAxisParameter = _.find(templateParameters, function (parameter) { return parameter.Ident === chart.AxisX.custom.parameterIdent; });
        var series = _.filter(chart.Series, function (series) {
            return _.any(templateParameters, function (parameter) { return parameter.Ident === series.parameterIdent; });
        });
        return _.map(series, function (series) {
            var seriesParameter = _.find(templateParameters, function (parameter) { return parameter.Ident === series.parameterIdent; });
            return _this.getSingleSeries(series, chart, xAxisParameter, seriesParameter);
        }).join(',\n\t\t\t');
    };
    ChartFormulaFactory.prototype.getSingleSeries = function (series, chart, axisXParameter, seriesParameter) {
        var points;
        if (this.isSerieExternalArray(seriesParameter.ParameterType)) {
            var valueType = seriesParameter.ParameterType.substring(0, seriesParameter.ParameterType.length - 2);
            points = "%".concat(seriesParameter.Ident, "%\n                    .Select(record => new {\n                        X = (((").concat(valueType, ")record).Timestamp - DateTime.UnixEpoch).TotalMilliseconds,\n                        Y = (record as object is IReportParameterValueForCalculator value1 ? value1.Value : (double)record)\n                    })\n                    .Select((a, index) =>\n                    @$\"{{\n                        x: {a.X.ToString(\"0.00\", CultureInfo.InvariantCulture)},\n                        y: {a.Y.ToString(\"0.00\", CultureInfo.InvariantCulture)}");
        }
        else {
            points = "categories\n                    .Zip(".concat(this.getParameterArray(chart.AxisX, seriesParameter), ", (x, y) => new {\n                        X = x,\n                        Y = (y as object is IReportParameterValueForCalculator value ? value.Value : (double)y)\n                    })\n                    .Select((a, index) =>\n                    @$\"{{\n                        ").concat(chart.AxisX.mode == 1 &&
                (_.isUndefined(axisXParameter) || _.contains(ChartParameterTypes.stringArrayTypes, axisXParameter === null || axisXParameter === void 0 ? void 0 : axisXParameter.ParameterType))
                ? "name: '{a.X}'"
                : 'x: {a.X.ToString("0.00", CultureInfo.InvariantCulture)}', ",\n                        y: {a.Y.ToString(\"0.00\", CultureInfo.InvariantCulture)}");
        }
        if (chart.Type === 0) {
            return "{{\n                lineWidth: ".concat(series.lineSize, ",\n                ").concat(this.getDashStyle(series), ",\n                ").concat(this.getLineType(series), ",\n                name:'").concat(series.parameterIdent, "',\n                marker: ").concat(this.getMarker(series), ",\n                color: '").concat(series.color, "',\n                data: [{string.Join(\", \", ").concat(points).concat(series.callout
                ? ",\n                        {((index >= ".concat(series.callout.labelOffset, " && ((index + ").concat(series.callout.labelOffset, ") % ").concat(series.callout.labelInterval, " == 0)) ? @$\"").concat(this.getDataLabels(series), "\" : null)}")
                : '', "\n                    }}\"))\n                }],\n            }}");
        }
        if (chart.Type === 1 || chart.Type === 2) {
            return "{{\n        name: '".concat(series.parameterIdent, "',\n        color: '").concat(series.color, "',\n        data: [{string.Join(@\", \", ").concat(points).concat(series.callout
                ? ",\n                {((index >= ".concat(series.callout.labelOffset, " && ((index + ").concat(series.callout.labelOffset, ") % ").concat(series.callout.labelInterval, " == 0)) ? @$\"").concat(this.getDataLabels(series), "\" : null)}")
                : '', "\n            }}\"))\n        }],\n    }}");
        }
    };
    ChartFormulaFactory.prototype.isSerieExternalArray = function (parameterType) {
        return parameterType == 'OpcValue[]'
            || parameterType == 'WinccOaValue[]'
            || parameterType == 'WinccValue[]'
            || parameterType == 'PiramidaValue[]';
    };
    ChartFormulaFactory.prototype.getLineType = function (series) {
        return "type: ".concat(series.type === 1 ? "'spline'" : "'line'").concat(series.type === 2
            ? ",\n                    step: 'center'"
            : '');
    };
    ChartFormulaFactory.prototype.getDashStyle = function (series) {
        var _a, _b;
        var js = (_b = (_a = _.find(this.lineDashStyles, function (x) { return x.dashStyle === series.lineDashStyle; })) === null || _a === void 0 ? void 0 : _a.js) !== null && _b !== void 0 ? _b : "'solid'";
        return "dashStyle: '".concat(js, "'");
    };
    ChartFormulaFactory.prototype.getMarker = function (series) {
        return "{{\n                    symbol: '".concat(series.marker.shape, "',\n                    fillColor: '").concat(series.marker.color, "',\n                    radius: ").concat(series.marker.size, ",\n                    width: ").concat(series.marker.size, ",\n                    height: ").concat(series.marker.size, "\n                }}");
    };
    ChartFormulaFactory.prototype.getDataLabels = function (series) {
        var xOffset = this.getXCalloutsOffset(series.callout);
        var yOffset = this.getYCalloutsOffset(series.callout);
        return "\n                        dataLabels:\n                        {{\n                            enabled: true,\n                            useHtml: true,\n                            color: '".concat(series.callout.color, "',\n                            format: '{{y:.2f}}',\n                            style:\n                            {{\n                                fontSize: '").concat(series.callout.fontSize, "px',\n                                fontWeight: 'normal'\n                            }},\n                            ").concat(series.callout.alignmentStyles !== 0
            ? "x: ".concat(xOffset, ",\n                            y: ").concat(yOffset, ",\n                            align:'").concat(xOffset === 0 ? 'center' : xOffset > 0 ? 'right' : 'left', "',\n                            verticalAlign:'").concat(yOffset === 0 ? 'middle' : yOffset > 0 ? 'top' : 'bottom', "',")
            : '', "\n                            ").concat(series.callout.alignmentStyles === 10
            ? 'rotation: -90,'
            : '', "\n                            crop: false,\n                            allowOverlap: true,\n                        }}");
    };
    ChartFormulaFactory.prototype.getXCalloutsOffset = function (callouts) {
        if (callouts.alignmentStyles === 8 ||
            callouts.alignmentStyles === 3 ||
            callouts.alignmentStyles === 6) {
            return -callouts.distanceFromPoint;
        }
        if (callouts.alignmentStyles === 7 ||
            callouts.alignmentStyles === 4 ||
            callouts.alignmentStyles === 5) {
            return callouts.distanceFromPoint;
        }
        return 0;
    };
    ChartFormulaFactory.prototype.getYCalloutsOffset = function (callouts) {
        if (callouts.alignmentStyles === 5 ||
            callouts.alignmentStyles === 1 ||
            callouts.alignmentStyles === 6 ||
            callouts.alignmentStyles === 10) {
            return -callouts.distanceFromPoint;
        }
        if (callouts.alignmentStyles === 7 ||
            callouts.alignmentStyles === 2 ||
            callouts.alignmentStyles === 8) {
            return callouts.distanceFromPoint;
        }
        return 0;
    };
    ChartFormulaFactory.prototype.getYAxis = function (chart) {
        if (this.isPieChart(chart)) {
            return '';
        }
        return "\n        yAxis: [{{\n            ".concat(this.getPlotLines(chart.PlotLines), "labels: {{\n                style: {{\n                    color: 'rgb(100, 100, 100)',\n                    cursor: 'default',\n                    fontSize: '12px'\n                }}\n            }},\n            gridLineColor: 'rgb(220, 220, 220)',\n            lineColor: 'rgb(100, 100, 100)',\n            title: {{\n                enabled: false\n            }},\n            type: 'linear',").concat(this.getYAxisRange(chart.AxisY), "\n        }}],\n");
    };
    ChartFormulaFactory.prototype.getPlotLines = function (plotLines) {
        var _this = this;
        return "plotLines: [\n                ".concat(_.map(plotLines, function (plotLine) { return "{{\n                    value: {(%".concat(plotLine.parameterIdent, "%).ToString(\"0.00\", CultureInfo.InvariantCulture)},\n                    color: '").concat(plotLine.color, "',\n                    dashStyle: '").concat(_this.lineDashStyles[plotLine.dashStyle].js, "',\n                    width: ").concat(plotLine.width, ",\n                    zIndex: 5,\n                    label: {{\n                        text: '").concat(plotLine.parameterIdent, "',\n                        align: 'right'\n                    }}\n                }}"); }).join(', '), "\n            ],\n            ");
    };
    ChartFormulaFactory.prototype.getYAxisRange = function (yAxis) {
        return "".concat(yAxis.min !== null
            ? "\n            min: ".concat(yAxis.min, ",")
            : '').concat(yAxis.max !== null
            ? "\n            max: ".concat(yAxis.max, ",")
            : '').concat(yAxis.tickInterval !== null
            ? "\n            tickInterval: ".concat(yAxis.tickInterval)
            : '');
    };
    ChartFormulaFactory.prototype.getAxisX = function (chart, xAxisParameter) {
        var _a;
        if (this.isPieChart(chart)) {
            return '';
        }
        return "\n        xAxis: [{{\n            gridLineWidth: 1,\n            type: ".concat(this.getAxisXType(chart.AxisX, xAxisParameter), ",\n            ").concat(chart.AxisX.mode === 1 && !this.isDigitalArray(xAxisParameter)
            ? "categories: [{string.Join(\", \", categories.Select(c => $\"'{c}'\"))}],"
            : '', "\n            labels: {{\n                style: {{\n                    color: 'rgb(100, 100, 100)',\n                    cursor: 'default',\n                    fontSize: '12px',\n                }},\n                rotation: ").concat(this.getRotation(chart.AxisX), ",\n                ").concat(this.isAutoAxisX(chart.AxisX) ? this.getFormat((_a = chart.AxisX.auto) === null || _a === void 0 ? void 0 : _a.dateTimeFormat) : '', "\n            }},\n            gridLineColor: 'rgb(220, 220, 220)',\n            lineColor: 'rgb(100, 100, 100)',\n            ").concat(this.getAxisXRange(chart.AxisX, xAxisParameter), "\n        }}],\n");
    };
    ChartFormulaFactory.prototype.getParameterArray = function (axisX, parameter) {
        if (this.isDigitalArray(parameter)) {
            return "%".concat(parameter.Ident, "%\n                    .Select(y => (double)y)\n                    .Concat(Enumerable.Repeat<double>(0, Math.Max(categories.Count() - %").concat(parameter.Ident, "%.Count(), 0)))");
        }
        if (axisX.mode === 0) {
            return "GetParameterValuesByTimestamps(\"%".concat(parameter.Ident, "%\", timestamps).Select(x => x.Value).Where(x => x != null).ToList()");
        }
        if (axisX.mode === 1) {
            return "Enumerable.Repeat<double>(double.Parse((%".concat(parameter.Ident, "%).ToString()), categories.Count())");
        }
    };
    ChartFormulaFactory.prototype.getCategories = function (axisX) {
        if (axisX.mode === 0) {
            return "var start = StartDate;\nvar end = EndDate;\nvar step = StepEnd - StepStart;\nvar stepCount = (int)((end.Ticks - start.Ticks) / step.Ticks);\nvar timestamps = Enumerable.Range(1, stepCount).Select(x => new DateTime((x * step.Ticks) + start.Ticks));\n\nvar categories = timestamps\n    .Select(x => (x - DateTime.UnixEpoch).TotalMilliseconds)\n    .ToList();\n\n";
        }
        if (axisX.mode === 1) {
            var categories = _.isUndefined(axisX.custom.parameterIdent)
                ? 'new string[] { "" }'
                : "%".concat(axisX.custom.parameterIdent, "%.ToArray()");
            return "var categories = ".concat(categories, ";\n\n");
        }
    };
    ChartFormulaFactory.prototype.getAxisXType = function (axisX, xAxisParameter) {
        if (axisX.mode === 0) {
            return "'datetime'";
        }
        if (axisX.mode === 1) {
            if (this.isDigitalArray(xAxisParameter)) {
                return "'number'";
            }
        }
        return "'string'";
    };
    ChartFormulaFactory.prototype.getRotation = function (axisX) {
        return this.isAutoAxisX(axisX) ? '-90' : '0';
    };
    ChartFormulaFactory.prototype.getFormat = function (dateTimeFormat) {
        return "format: '{{value:".concat("".concat(dateTimeFormat !== null && dateTimeFormat !== void 0 ? dateTimeFormat : '%H:%M %d.%m'), "}}'");
    };
    ChartFormulaFactory.prototype.getAxisXRange = function (xAxis, xAxisParameter) {
        if (!this.isAutoAxisX(xAxis) && !this.isDigitalArray(xAxisParameter)) {
            return '';
        }
        return "".concat(this.isAutoAxisX(xAxis)
            ? _.isUndefined(xAxis.auto.minParameterIdent)
                ? ''
                : "min: {(%".concat(xAxis.auto.minParameterIdent, "% - DateTime.UnixEpoch).TotalMilliseconds},\n            ")
            : _.isUndefined(xAxis.custom.minParameterIdent)
                ? ''
                : "min: {%".concat(xAxis.custom.minParameterIdent, "%},\n            ")).concat(this.isAutoAxisX(xAxis)
            ? _.isUndefined(xAxis.auto.maxParameterIdent)
                ? ''
                : "max: {(%".concat(xAxis.auto.maxParameterIdent, "% - DateTime.UnixEpoch).TotalMilliseconds},\n            ")
            : _.isUndefined(xAxis.custom.maxParameterIdent)
                ? ''
                : "max: {%".concat(xAxis.custom.maxParameterIdent, "%},\n            ")).concat(this.isAutoAxisX(xAxis)
            ? "tickInterval: ".concat(dateHelper.getTimespan(xAxis.auto.tickInterval).getTime())
            : _.isDefined(xAxis.custom.tickInterval)
                ? "tickInterval: ".concat(xAxis.custom.tickInterval)
                : '');
    };
    ChartFormulaFactory.prototype.getChartType = function (chart) {
        if (chart.Type === 0) {
            return 'line';
        }
        if (chart.Type === 1 || chart.Type === 2) {
            return 'column';
        }
        if (chart.Type === 3) {
            return 'pie';
        }
    };
    ChartFormulaFactory.prototype.getLegend = function (chart) {
        if (chart.LegendPosition === 0) {
            return "legend: {{\n            enabled: false \n        }},\n";
        }
        return "legend: {{\n            enabled: true,\n            itemStyle: {{\n                fontWeight: 'normal',\n                color: 'rgb(100, 100, 100)'\n            }},\n            ".concat(this.getLegendLayout(chart.LegendPosition), "\n        }},\n");
    };
    ChartFormulaFactory.prototype.getLegendLayout = function (legendPosition) {
        if (legendPosition === 2) {
            return "layout: 'horizontal',\n            verticalAlign: 'top',\n            align: 'center'";
        }
        if (legendPosition === 4) {
            return "layout: 'vertical',\n            verticalAlign: 'middle',\n            align: 'right'";
        }
        if (legendPosition === 1) {
            return "layout: 'horizontal',\n            verticalAlign: 'bottom',\n            align: 'center'";
        }
        if (legendPosition === 3) {
            return "layout: 'vertical',\n            verticalAlign: 'middle',\n            align: 'left'";
        }
        return "";
    };
    ChartFormulaFactory.prototype.isPieChart = function (chart) {
        return chart.Type === 3;
    };
    ChartFormulaFactory.prototype.isDigitalArray = function (parameter) {
        return _.contains(ChartParameterTypes.digitalArrayTypes, parameter === null || parameter === void 0 ? void 0 : parameter.ParameterType);
    };
    ChartFormulaFactory.prototype.isAutoAxisX = function (axisX) {
        return axisX.mode === 0;
    };
    ChartFormulaFactory.$inject = ['language'];
    return ChartFormulaFactory;
}());
angular.module('kamhpp').service('chartFormulaFactory', ChartFormulaFactory);
