var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var SwitchoverForm = (function () {
    function SwitchoverForm(form) {
        this.steps = [];
        this.id = form.id;
        this.templateId = form.templateId;
        this.name = form.name;
        this.description = form.description;
        this.serialNumber = form.serialNumber;
        this.headerHtml = form.headerHtml;
        this.footerHtml = form.footerHtml;
        this.status = form.status;
        this.creationDate = form.creationDate;
        this.closeDate = form.closeDate;
        this.stopDate = form.stopDate;
        this.stopReason = form.stopReason;
        this.stopUserFullName = form.stopUserFullName;
        this.alarms = form.alarms;
        this.conditions = this.setConditionsUiOrder(form.conditions);
        this.operations = this.setOperationsUiOrder(form.conditions, form.operations);
        this.steps = __spreadArray(__spreadArray([], this.conditions, true), this.operations, true);
        this.currentStepIndex = this.getCurrentStepIndex();
    }
    Object.defineProperty(SwitchoverForm.prototype, "currentStepOrderNumber", {
        get: function () {
            return this.currentStepIndex === -1 ? this.steps.length + 1 : this.currentStepIndex + 1;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SwitchoverForm.prototype, "currentStep", {
        get: function () {
            return this.currentStepIndex === -1 ? null : this.steps[this.currentStepIndex];
        },
        enumerable: false,
        configurable: true
    });
    SwitchoverForm.prototype.nextStep = function () {
        this.currentStepIndex = this.getCurrentStepIndex();
    };
    SwitchoverForm.prototype.prevStep = function () {
        this.currentStepIndex = this.getCurrentStepIndex();
    };
    SwitchoverForm.prototype.isCompleted = function () {
        var _this = this;
        return _.all(this.steps, function (step) { return _this.isTextStep(step.type) || _this.isSuccessStep(step.status); });
    };
    SwitchoverForm.prototype.isProcessed = function () {
        return _.any(this.steps, function (step) { return step.isProcessed; });
    };
    SwitchoverForm.prototype.getCompleteDate = function () {
        return this.closeDate || this.stopDate;
    };
    SwitchoverForm.prototype.getCurrentStepIndex = function () {
        var _this = this;
        return _.findIndex(this.steps, function (step) { return !_this.isTextStep(step.type) && !_this.isSuccessStep(step.status); });
    };
    SwitchoverForm.prototype.isSuccessStep = function (status) {
        return (status === 2 ||
            status === 1 ||
            status === 2 ||
            status === 1);
    };
    SwitchoverForm.prototype.getLastSuccessStep = function () {
        var _this = this;
        var successSteps = _.filter(this.steps, function (step) { return _this.isSuccessStep(step.status); });
        return successSteps.length !== 0 ? successSteps[successSteps.length - 1] : null;
    };
    SwitchoverForm.prototype.isTextStep = function (type) {
        return type === 2 || type === 2;
    };
    SwitchoverForm.prototype.setConditionsUiOrder = function (conditions) {
        var conditionOrder = 0;
        _.forEach(_.sortBy(conditions, function (c) { return c.orderNumber; }), function (condition) {
            if (condition.type === 2) {
                return;
            }
            if (!condition.isOrderNumberHidden) {
                conditionOrder++;
            }
            condition.uiOrderNumber = conditionOrder;
        });
        return conditions;
    };
    SwitchoverForm.prototype.setOperationsUiOrder = function (conditions, operations) {
        var operationOrder = 0;
        _.forEach(_.sortBy(operations, function (o) { return o.orderNumber; }), function (operation) {
            if (operation.type === 2) {
                return;
            }
            if (!operation.isOrderNumberHidden) {
                operationOrder++;
            }
            operation.uiOrderNumber = operationOrder;
        });
        return operations;
    };
    return SwitchoverForm;
}());
