var SwitchoverFormTemplate = (function () {
    function SwitchoverFormTemplate(template) {
        this.id = template.id;
        this.name = template.name;
        this.description = template.description;
        this.headerHtml = template.headerHtml;
        this.footerHtml = template.footerHtml;
        this.chapterName = template.chapterName;
        this.isTypical = template.isTypical;
        this.creationDate = angular.copy(template.creationDate);
        this.createdUserName = template.createdUserName;
        this.parentTemplateId = template.parentTemplateId;
        this.alarms = angular.copy(template.alarms);
        this.attachments = angular.copy(template.attachments);
        this.conditions = _.sortBy(angular.copy(template.conditions), function (c) { return c.orderNumber; });
        this.operations = _.sortBy(angular.copy(template.operations), function (o) { return o.orderNumber; });
        this.updateStepUiOrderNumber();
    }
    SwitchoverFormTemplate.prototype.updateStepUiOrderNumber = function () {
        var _this = this;
        var itemOrder = 0;
        _.forEach(this.conditions, function (condition, index) {
            if (condition.switchoverFormCommonCondition.type === 2) {
                return;
            }
            if (condition.isOrderNumberHidden &&
                (itemOrder === 0 ||
                    (index > 0 &&
                        _this.conditions[index - 1].switchoverFormCommonCondition.type ===
                            2))) {
                condition.isOrderNumberHidden = false;
            }
            if (!condition.isOrderNumberHidden) {
                itemOrder++;
            }
            condition.uiOrderNumber = itemOrder;
        });
        itemOrder = 0;
        _.forEach(this.operations, function (operation, index) {
            if (operation.switchoverFormCommonOperation.type === 2) {
                return;
            }
            if (operation.isOrderNumberHidden &&
                (itemOrder === 1 ||
                    (index > 0 &&
                        _this.operations[index - 1].switchoverFormCommonOperation.type ===
                            2))) {
                operation.isOrderNumberHidden = false;
            }
            if (!operation.isOrderNumberHidden) {
                itemOrder++;
            }
            operation.uiOrderNumber = itemOrder;
        });
    };
    return SwitchoverFormTemplate;
}());
