var SwitchoverFormOperationExportModalCtrl = (function () {
    function SwitchoverFormOperationExportModalCtrl(scope, $modalInstance, operations) {
        this.scope = scope;
        this.$modalInstance = $modalInstance;
        this.operations = operations;
        this.isAllOperatonsSelected = true;
        this.isNoneOperationsSelected = false;
        this.scope.ctrl = this;
        this.operationOptions = _.map(operations, function (t) {
            return {
                description: t.description,
                id: t.id,
                isSelected: true,
            };
        });
    }
    SwitchoverFormOperationExportModalCtrl.prototype.changeAllOperationOptionsStatus = function () {
        var currentStatus = this.isAllOperatonsSelected;
        _.forEach(this.operationOptions, function (t) {
            t.isSelected = !currentStatus;
        });
        this.isAllOperatonsSelected = !currentStatus;
        this.isNoneOperationsSelected = currentStatus;
    };
    SwitchoverFormOperationExportModalCtrl.prototype.changeOptionSelectStatus = function (option) {
        if (_.isDefined(option)) {
            option.isSelected = !option.isSelected;
        }
        this.isAllOperatonsSelected = _.all(this.operationOptions, function (o) { return o.isSelected; });
        this.isNoneOperationsSelected = _.all(this.operationOptions, function (o) { return !o.isSelected; });
    };
    SwitchoverFormOperationExportModalCtrl.prototype.ok = function () {
        this.$modalInstance.close({
            ids: _.map(_.where(this.operationOptions, function (t) { return t.isSelected; }), function (t) { return t.id; }),
            format: 7,
        });
    };
    SwitchoverFormOperationExportModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    SwitchoverFormOperationExportModalCtrl.$inject = ['$scope', '$modalInstance', 'operations'];
    return SwitchoverFormOperationExportModalCtrl;
}());
angular.module('kamhpp').controller('switchoverFormOperationExportModalCtrl', SwitchoverFormOperationExportModalCtrl);
