var SwitchoverFormConditionImportModalCtrl = (function () {
    function SwitchoverFormConditionImportModalCtrl($scope, $modalInstance, languageService, $upload, clientSettings, contentFiles, fileType) {
        var _this = this;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.languageService = languageService;
        this.$upload = $upload;
        this.clientSettings = clientSettings;
        this.contentFiles = contentFiles;
        this.fileType = fileType;
        this.isAllConditionsSelected = true;
        this.isNoneConditionsSelected = false;
        this.getOptionImportStatus = function (status) {
            switch (status) {
                case 1:
                    return _this.languageService.getElementValue('importStatusAddedHdr');
                case 2:
                    return _this.languageService.getElementValue('importStatusUpdatedHdr');
                default:
                    return _this.languageService.getElementValue('importStatusNonHdr');
            }
        };
        this.$scope.ctrl = this;
        switch (fileType) {
            case 6: {
                this.importProvider = new SwitchoverFormImportProviderJson(this.clientSettings.getServerInstance(), '/SwitchoverFormTypicalConditionsImport/GetDocxImportInfo', '/SwitchoverFormTypicalConditionsImport/ImportFromDocx');
                break;
            }
            case 7: {
                this.importProvider = new SwitchoverFormImportProviderJson(this.clientSettings.getServerInstance(), '/SwitchoverFormTypicalConditionsImport/GetJsonImportInfo', '/SwitchoverFormTypicalConditionsImport/ImportFromJson');
                break;
            }
        }
        this.importProvider.files = contentFiles;
        $upload
            .upload($scope.ctrl.importProvider.getImportInfoForSelect())
            .then(function (result) {
            $scope.ctrl.importProvider.importOptions = _.map(result.data, function (r) {
                return {
                    info: r,
                    isSelected: true,
                };
            });
        });
    }
    SwitchoverFormConditionImportModalCtrl.prototype.changeAllConditionOptionsStatus = function () {
        var currentStatus = this.isAllConditionsSelected;
        _.forEach(this.importProvider.importOptions, function (o) {
            o.isSelected = !currentStatus;
        });
        this.isAllConditionsSelected = !currentStatus;
        this.isNoneConditionsSelected = currentStatus;
    };
    SwitchoverFormConditionImportModalCtrl.prototype.changeOptionSelectStatus = function (option) {
        if (_.isDefined(option)) {
            option.isSelected = !option.isSelected;
        }
        this.isAllConditionsSelected = _.all(this.importProvider.importOptions, function (o) { return o.isSelected; });
        this.isNoneConditionsSelected = _.all(this.importProvider.importOptions, function (o) { return !o.isSelected; });
    };
    SwitchoverFormConditionImportModalCtrl.prototype.isAnyFileSelected = function () {
        return _.isDefined(this.importProvider.files) && _.any(this.importProvider.files);
    };
    SwitchoverFormConditionImportModalCtrl.prototype.ok = function () {
        this.$modalInstance.close(this.importProvider.getImportInfoForImport());
    };
    SwitchoverFormConditionImportModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    SwitchoverFormConditionImportModalCtrl.$inject = ['$scope', '$modalInstance', 'language', '$upload', 'clientSettings', 'contentFiles', 'fileType'];
    return SwitchoverFormConditionImportModalCtrl;
}());
angular.module('kamhpp').controller('switchoverFormConditionImportModalCtrl', SwitchoverFormConditionImportModalCtrl);
