String.prototype.startsWith = function (searchString, position) {
    position = position || 0;
    return this.indexOf(searchString, position) === position;
};
String.prototype.endsWith = function (searchString, endPosition) {
    return this.indexOf(searchString, this.length - searchString.length) !== -1;
};
String.prototype.contains = function (subStr) {
    return this.indexOf(subStr) > -1;
};
String.prototype.replaceAllPolyfill = function (search, replacement) {
    return this.split(search).join(replacement);
};
String.prototype.escapeSymbol = function (symbol, escapeSymbol) {
    if (escapeSymbol === void 0) { escapeSymbol = '"'; }
    return this.replaceAll(symbol, escapeSymbol + symbol);
};
String.prototype.escapeRegExp = function () {
    return this.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
};
