var Scale = (function () {
    function Scale(value, step, maxValue, minValue) {
        if (value === void 0) { value = 1; }
        if (step === void 0) { step = 0.25; }
        if (maxValue === void 0) { maxValue = 4; }
        if (minValue === void 0) { minValue = 0.25; }
        this.value = value;
        this.step = step;
        this.maxValue = maxValue;
        this.minValue = minValue;
    }
    Scale.prototype.increase = function () {
        this.change(this.step);
    };
    Scale.prototype.decrease = function () {
        this.change(-this.step);
    };
    Scale.prototype.canIncrease = function () {
        return this.value + this.step <= this.maxValue;
    };
    Scale.prototype.canDecrease = function () {
        return this.value - this.step >= this.minValue;
    };
    Scale.prototype.change = function (step) {
        var newScale = this.value + step;
        if (newScale > this.maxValue && newScale < this.minValue) {
            return;
        }
        this.value = newScale;
    };
    return Scale;
}());
