var BacklightCondition = (function () {
    function BacklightCondition() {
        this.left = null;
        this.comparator = 1;
        this.right = 0.0;
    }
    BacklightCondition.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new BacklightCondition();
        clone.comparator = obj.comparator;
        clone.left = obj.left;
        clone.right = obj.right;
        return clone;
    };
    BacklightCondition.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return obj.comparator === other.comparator && obj.left === other.left && obj.right === other.right;
    };
    return BacklightCondition;
}());
var ReportParameterBacklight = (function () {
    function ReportParameterBacklight() {
        this.condition = new BacklightCondition();
        this.colorHex = '#D4E157';
        this.conditionType = 0;
        this.parameterIdent = '';
    }
    ReportParameterBacklight.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = {
            condition: BacklightCondition.clone(obj.condition),
            colorHex: obj.colorHex,
            conditionType: obj.conditionType,
            parameterIdent: obj.parameterIdent,
        };
        return clone;
    };
    ReportParameterBacklight.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (BacklightCondition.isEqual(obj.condition, other.condition) &&
            obj.colorHex === other.colorHex &&
            obj.conditionType === other.conditionType &&
            obj.parameterIdent === other.parameterIdent);
    };
    return ReportParameterBacklight;
}());
