var ReportPageSettings = (function () {
    function ReportPageSettings(name, size, paddings) {
        if (size === void 0) { size = null; }
        if (paddings === void 0) { paddings = null; }
        this.name = name;
        this.paddings = paddings !== null && paddings !== void 0 ? paddings : new ReportPagePaddings();
        this.size = size !== null && size !== void 0 ? size : new ReportPageSize();
    }
    ReportPageSettings.createFrom = function (element) {
        var _a, _b, _c, _d, _e, _f;
        var pageName = element.getAttribute(ReportPageSettings.pageAttribute) || element.getAttribute('name');
        var pageSize = new ReportPageSize();
        pageSize.height = (_a = ReportPageSettings.getPropertyValue(element.style.height)) !== null && _a !== void 0 ? _a : pageSize.height;
        pageSize.width = (_b = ReportPageSettings.getPropertyValue(element.style.width)) !== null && _b !== void 0 ? _b : pageSize.width;
        var pagePaddings = new ReportPagePaddings();
        pagePaddings.top = (_c = ReportPageSettings.getPropertyValue(element.style.paddingTop)) !== null && _c !== void 0 ? _c : pagePaddings.top;
        pagePaddings.left = (_d = ReportPageSettings.getPropertyValue(element.style.paddingLeft)) !== null && _d !== void 0 ? _d : pagePaddings.left;
        pagePaddings.right = (_e = ReportPageSettings.getPropertyValue(element.style.paddingRight)) !== null && _e !== void 0 ? _e : pagePaddings.right;
        pagePaddings.bottom = (_f = ReportPageSettings.getPropertyValue(element.style.paddingBottom)) !== null && _f !== void 0 ? _f : pagePaddings.bottom;
        return new ReportPageSettings(pageName, pageSize, pagePaddings);
    };
    ReportPageSettings.getPropertyValue = function (value) {
        if (_.isUndefined(value)) {
            return null;
        }
        var result = parseFloat(value.slice(0, -2));
        return !_.isNaN(result)
            ? result
            : null;
    };
    ReportPageSettings.pageTag = 'div';
    ReportPageSettings.pageAttribute = 'data-report-page';
    ReportPageSettings.width = 'width';
    ReportPageSettings.heght = 'height';
    ReportPageSettings.paddingTop = 'padding-top';
    ReportPageSettings.paddingRight = 'padding-right';
    ReportPageSettings.paddingBottom = 'padding-bottom';
    ReportPageSettings.paddingLeft = 'padding-left';
    return ReportPageSettings;
}());
var ReportPagePaddings = (function () {
    function ReportPagePaddings(top, right, bottom, left) {
        if (top === void 0) { top = 10; }
        if (right === void 0) { right = 10; }
        if (bottom === void 0) { bottom = 10; }
        if (left === void 0) { left = 10; }
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }
    ReportPagePaddings.prototype.toCssString = function () {
        return "".concat(this.top, "mm ").concat(this.right, "mm ").concat(this.bottom, "mm ").concat(this.left, "mm");
    };
    return ReportPagePaddings;
}());
var ReportPageSize = (function () {
    function ReportPageSize(width, height) {
        if (width === void 0) { width = null; }
        if (height === void 0) { height = null; }
        this.width = width;
        this.height = height;
    }
    return ReportPageSize;
}());
